<?php

use yii\helpers\Html;
use yii\grid\GridView;
use yii\helpers\ArrayHelper;

$this->title = Yii::t('app', 'UI/UX Element');
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="wrapper wrapper-content">
    <p><?= Html::a(Yii::t('app', 'Create Element'), ['create'], ['class' => 'btn btn-primary']) ?></p>
    <div class="ibox animated fadeInRightx">
        <div class="mail-box b-r-md">
            <?=
            GridView::widget([
                'dataProvider' => $dataProvider,
                'filterModel' => $searchModel,
                'tableOptions' => ['class' => 'table table-hover table-mail table-custom',],
                'summary' => '',
                'columns' => [
                    ['class' => 'yii\grid\SerialColumn'],
                    [
                        'header' => 'Image',
                        'filter' => false,
                        'format' => 'raw',
                        'headerOptions' => ['style' => 'width:1%'],
                        'value' => function ($model) {
                            return '<img style="border:1px solid #ccc;width:150px;" src="' . Yii::getAlias('@web') . '/' . $model->element_img . '"/>';
                        }
                    ],
                    'element_title',
                    [
                        'attribute' => 'element_type',
                        'filter' => ArrayHelper::map(
                                (new \yii\db\Query())->select(['code', 'descr'])
                                        ->from('ref')
                                        ->where(['=', 'cat', 'UIUX_ELEMENT_TYPE'])
                                        ->orderBy(['descr' => SORT_ASC])
                                        ->all(), 'code', 'descr'),
                        'value' => function ($model) {
                            $ref = (new \yii\db\Query())->select(['descr'])
                                    ->from('ref')
                                    ->where(['=', 'cat', 'UIUX_ELEMENT_TYPE'])
                                    ->andwhere(['=', 'code', $model->element_type])
                                    ->one();
                            if (!empty($ref))
                                return $ref['descr'];
                        }
                    ],
                    'element_descr',
                    [
                        'class' => 'yii\grid\ActionColumn',
                        'header' => 'Action',
                        'template' => '{update} {delete}',
                        'headerOptions' => ['style' => 'text-align:center;width:10%'],
                        'contentOptions' => ['style' => 'text-align:center;'],
                    ],
                ],
            ]);
            ?>
        </div>
    </div>
</div>
