<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use kartik\file\FileInput;
use yii\helpers\ArrayHelper;
use common\assets\AceEditorAsset;

AceEditorAsset::register($this);

$this->registerJs(
        <<<JS
var textarea = $('#uiuxtemplates-element_content').hide();
var editor = ace.edit('editorContent');
    editor.setOptions({maxLines: Infinity,});
    editor.setTheme("ace/theme/monokai");
    editor.getSession().setMode("ace/mode/html");
    editor.getSession().setValue(textarea.val());
    editor.getSession().on('change', function () {
        textarea.val(editor.getSession().getValue());
    });
JS
);

$this->registerJs('updatepreview()');
?>
<style type="text/css" media="screen">
    .ace_editor  { min-height:300px; z-index:9999; }
    .ace_text-input{  position:absolute!important }
    #editorContent{margin-bottom:2em;}
    .field-frontendcontentelement-element_content {margin:0 !important;}
    .field-frontendcontentelement-element_content .help-block{margin:0 !important;}
</style>
<div class="frontend-content-element-form">
    <div class="wrapper wrapper-content animated fadeInRight">
        <div class="ibox float-e-margins">
            <div class="ibox-content">
                <?php $form = ActiveForm::begin(); ?>
                <?= $form->field($model, 'element_title')->textInput(['maxlength' => true]) ?>
                <?=
                $form->field($model, 'element_type')->dropdownList(
                        ArrayHelper::map(
                                (new \yii\db\Query())->select(['code', 'descr'])
                                        ->from('ref')
                                        ->where(['=', 'cat', 'UIUX_ELEMENT_TYPE'])
                                        ->orderBy(['descr' => SORT_ASC])
                                        ->all(), 'code', 'descr'), [
                    'maxlength' => true, 'prompt' => '-- Please choose --'])
                ?>
                <?= $form->field($model, 'element_descr')->textarea(['rows' => 6]) ?>
                <?php echo $form->field($model, 'element_img')->widget(FileInput::classname()); ?>
                <?= $form->field($model, 'element_content')->textarea(['rows' => 6]) ?>
                <div id="editorContent" onkeyup="updatepreview()"></div>
                <div class="form-group">
                    <?= Html::a(Yii::t('app', 'Back'), ['index'], ['class' => 'btn btn-primary']) ?>
                    <?= Html::submitButton(Yii::t('app', 'Submit'), ['class' => 'btn btn-primary']) ?>
                </div>
                <?php ActiveForm::end(); ?>
            </div>
        </div>
        <h3>Preview Content</h3>
        <div class="ibox float-e-margins">
            <div class="ibox-content">
                <div id="preview-content"></div>
            </div>
        </div>
    </div>
</div>
<script>
function updatepreview(){
    var content = $('#uiuxtemplates-element_content').val();
    $('#preview-content').html(content);
}
</script>