<?php

namespace backend\modules\uiuxBuilder\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\modules\uiuxBuilder\models\UiuxTemplates;

/**
 * UiuxTemplatesSearch represents the model behind the search form of `backend\modules\uiuxBuilder\models\UiuxTemplates`.
 */
class UiuxTemplatesSearch extends UiuxTemplates {

    /**
     * {@inheritdoc}
     */
    public function rules() {
        return [
            [['element_id', 'created_by', 'updated_by'], 'integer'],
            [['element_title', 'element_descr', 'element_img', 'element_content', 'created_at', 'updated_at', 'element_type'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios() {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params) {
        $query = UiuxTemplates::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider(['query' => $query, 'pagination' => ['pageSize' => 10,]]);
        $dataProvider->setSort(['defaultOrder' => ['element_title' => SORT_ASC]]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere(['like', 'element_title', $this->element_title])
                ->andFilterWhere(['like', 'element_descr', $this->element_descr])
                ->andFilterWhere(['like', 'element_type', $this->element_type])
                ->andFilterWhere(['like', 'element_content', $this->element_content]);

        return $dataProvider;
    }

}
