<?php

namespace backend\modules\uiuxBuilder\models;

use Yii;

/**
 * This is the model class for table "uiux_templates".
 *
 * @property int $element_id
 * @property string|null $element_title
 * @property string|null $element_type
 * @property string|null $element_descr
 * @property string|null $element_img
 * @property string|null $element_content
 * @property string|null $created_at
 * @property int|null $created_by
 * @property string|null $updated_at
 * @property int|null $updated_by
 */
class UiuxTemplates extends \yii\db\ActiveRecord {

    /**
     * {@inheritdoc}
     */
    public static function tableName() {
        return 'uiux_templates';
    }

    /**
     * {@inheritdoc}
     */
    public function rules() {
        return [
            [['element_descr', 'created_at', 'updated_at', 'created_by', 'updated_by'], 'safe'],
            [['element_title', 'element_content', 'element_type'], 'required'],
            [['element_img'], 'required', 'on' => 'create'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels() {
        return [
            'element_id' => 'Element ID',
            'element_title' => 'Title',
            'element_type' => 'Type',
            'element_descr' => 'Desription',
            'element_img' => 'Image',
            'element_content' => 'Content',
            'created_at' => 'Created At',
            'created_by' => 'Created By',
            'updated_at' => 'Updated At',
            'updated_by' => 'Updated By',
        ];
    }

}
