<?php

namespace backend\modules\uiuxBuilder\controllers;

use Yii;
use backend\modules\uiuxBuilder\models\UiuxTemplates;
use backend\modules\uiuxBuilder\models\UiuxTemplatesSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\web\UploadedFile;

/**
 * UiuxTemplatesController implements the CRUD actions for UiuxTemplates model.
 */
class UiuxTemplatesController extends Controller {

    /**
     * {@inheritdoc}
     */
    public function behaviors() {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all UiuxTemplates models.
     * @return mixed
     */
    public function actionIndex() {
        $searchModel = new UiuxTemplatesSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
                    'searchModel' => $searchModel,
                    'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single UiuxTemplates model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id) {
        return $this->render('view', [
                    'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new UiuxTemplates model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate() {
        $model = new UiuxTemplates();
        $model->scenario = 'create';
        $model->created_at = date("Y-m-d H:i:s");
        $model->created_by = Yii::$app->user->identity->id;
        $model->updated_at = date("Y-m-d H:i:s");
        $model->updated_by = Yii::$app->user->identity->id;
        if ($model->load(Yii::$app->request->post())) {

            $model->element_img = UploadedFile::getInstance($model, 'element_img');
            if (!empty($model->element_img)) {
                $element_img = 'images/modules/uiuxElement_' . date("YmdHis") . '.' . $model->element_img->extension;
                if ($model->element_img->saveAs($element_img))
                    $model->element_img = $element_img;
            }

            if ($model->save())
                return $this->redirect(['index']);
        }
        return $this->render('create', [
                    'model' => $model,
        ]);
    }

    /**
     * Updates an existing UiuxTemplates model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id) {
        $model = $this->findModel($id);
        $model->updated_at = date("Y-m-d H:i:s");
        $model->updated_by = Yii::$app->user->identity->id;
        $original_element_img = $model->element_img;
        if ($model->load(Yii::$app->request->post())) {

            $model->element_img = UploadedFile::getInstance($model, 'element_img');
            if (!empty($model->element_img)) {
                $element_img = 'images/modules/uiuxElement_' . date("YmdHis") . '.' . $model->element_img->extension;
                if ($model->element_img->saveAs($element_img))
                    $model->element_img = $element_img;
            } else
                $model->element_img = $original_element_img;

            if ($model->save())
                return $this->redirect(['index']);
        }
        return $this->render('update', [
                    'model' => $model,
        ]);
    }

    /**
     * Deletes an existing UiuxTemplates model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id) {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the UiuxTemplates model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return UiuxTemplates the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id) {
        if (($model = UiuxTemplates::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException(Yii::t('app', 'The requested page does not exist.'));
    }
    
    public function actionDesign() {
        return $this->renderpartial('design');
    }

    public function actionElement() {
        $output = '';
        $model = UiuxTemplates::find()->orderBy(['element_title' => SORT_ASC])->all();
        if (!empty($model)) {
            foreach ($model as $row) {
                $output .= '<div data-type="container" data-preview="' . Yii::getAlias('@web') . '/' . $row->element_img . '" data-keditor-title="' . $row->element_title . '" data-keditor-categories="' . \backend\modules\refdynawebv2\models\Ref::getDesc('UIUX_ELEMENT_TYPE', $row->element_type) . '">
                    ' . $row->element_content . '
                </div>';
            }
        }
        echo $output;
    }

}
