<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use backend\models\LayoutSkin;

/* @var $this yii\web\View */
/* @var $model backend\models\support\SupportTutorial */
$this->title = $model->support_tutorial_title;
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Support Tutorials'), 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="wrapper wrapper-content">
    <div class="ibox">
        <div class="ibox-title">
            <h1><?= Html::encode($this->title) ?></h1>
        </div>
        <div class="ibox-content clearfix">
            <?= DetailView::widget([
                'model' => $model,
                'attributes' => [
                    'support_tutorial_id',
                    'support_tutorial_title',
                    'support_tutorial_description',
                    [   
                        'label' => 'Pautan ',
                        'format' => 'raw',
                        'value' => function($model)
                        {
                            return '<iframe width="560" height="315" src="'.$model->support_tutorial_embeded_link.'" frameborder="0" allowfullscreen></iframe>';
                        },
                
                    ],
                    [
                       'value'=> function($model)
                        {
                            $roles = explode(",",$model->support_tutorial_role);
                            $rTrole  = "";
                            $rTrole .= "<p>";
                            foreach($roles as $role)
                            {   
                                if($role != "ALL")
                                {
                                    $rTrole .= $role . "<br>";
                                }else{
                                    $rTrole  .= "All<br>";
                                }
                            }
                            $rTrole .= "</p>";
                            return $rTrole;
                        },
                       'label'=> 'Peranan',
                       'format'=>'raw'
                    ],
                    'support_tutorial_createdat',
                    [
                       'value'=> function($model)
                       {
                          return  $model->user->staff_name;
                       },
                       'label'=>'Oleh'
                    ]
                ],
            ]) ?>
            <?=  Html::a(Yii::t('app','Back'),['index'],['class'=>'pull-right btn btn-sm btn-success']); ?>
        </div>
        </div>
    </div>
</div>
