<?php
use yii\helpers\Html;
use yii\widgets\DetailView;
use yii\web\View;
use yii\helpers\Url;
use yii\widgets\LinkPager;
use yii\data\Pagination;

$url = Url::to(['/support/support-tutorial/view-tutorial', 'pretty' => 1]);
$app = Yii::$app;
/* @var $this yii\web\View */
/* @var $model backend\models\support\SupportTutorial */
$this->title = 'Tutorial';
$this->params['breadcrumbs'][] = $this->title;
?>
    <style>
        .widget {
            border-radius: 0 0 5px 5px;
            margin-top: -4px;
        }
        
        video {
            width: 100% !important;
            height: auto !important;
        }
        
        iframe {
            width: 100% !important;
            /* height: auto !important; */
            min-height: 350px;
            border-radius: 5px 5px 0 0;
        }
        
        .pagination {
            position: relative;
            left: 40%;
        }
        
        h1 {
            display: inline-block;
        }
    </style>
    <?= $this->registerJs(
        "
        var c = '<span class=\"caret\"></span>&nbsp;&nbsp;';
        $('#t').click(function(){
            $('#sf').prop('disabled',false);
            $('#sbtn').html(c+' '+$(this).text());
            $('#sf').attr({ name: 'SupportTutorialSearch[support_tutorial_title]'});
            return false;
        });

        $('#d').click(function(){
            $('#sbtn').html(c+' '+$(this).text());
            $('#sf').prop('disabled',false);
            $('#sf').attr({ name: 'SupportTutorialSearch[support_tutorial_description]'});
            return false;
        });
        ", View::POS_READY,'id'); ?>
        <div class="wrapper wrapper-content clearfix">
            <div class="ibox">
                <div class="ibox-content clearfix">
                    <h2>
                        <?= Html::encode($this->title) ?>
                    </h2>
                    <div class="hr-line-dashed"></div>
                    <div class="col-md-12">
                        <div class="alert alert-info">Tekan Pada Butang <i class="fa fa-play-circle"></i> untuk memulakan video. Dan klik pada (<span class="caret"></span> Pilih carian ) untuk membuat pilihan carian</div>
                        <form class="form-horizontal" action="" method="get">
                            <div class="form-group">
                                <div class="col-sm-12">
                                    <div class="input-group m-b">
                                        <div class="input-group-btn">
                                            <div class="btn-group">
                                                <button data-toggle="dropdown" class="btn btn-default dropdown-toggle" type="button"><span class="caret"></span> Susunan</button>
                                                <ul class="dropdown-menu">
                                                    <li><a href="<?= $url ?>&sort=support_tutorial_createdat">Tarikh Menaik </a></li>
                                                    <li><a href="<?= $url ?>&sort=-support_tutorial_createdat">Tarikh Menurun</a></li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="input-group-btn">
                                            <button id='sbtn' data-toggle="dropdown" class="btn btn-white dropdown-toggle" type="button" aria-expanded="false"><span class="caret"></span> Pilih carian </button>
                                            <ul class="dropdown-menu">
                                                <li><a id="t" href="">Tajuk</a></li>
                                                <li><a id="d" href="">Diskripsi</a></li>
                                            </ul>
                                            <input type="hidden" name="r" value="support/support-tutorial/view-tutorial">
                                        </div>
                                        <input type="text" id="sf" name="" class="form-control" disabled>
                                        <span class="input-group-btn"> <button type="submit" class="btn btn-primary">Cari</button>
                                    </span>
                                    </div>
                                </div>
                            </div>
                        </form>

                        <?php  if(count($model) > 0 ): ?>
                        <?php foreach($model as $tutorial):?>

                        <?php 
                            //roles
                            $role  = $app->authManager->getRolesByUser($app->user->getId());
                            $trole =  explode(',', $tutorial->support_tutorial_role);
                            if (!array_intersect(array_keys($role), $trole)) {
                                continue;
                            }
                        ?>
                        <iframe src="<?= $tutorial->support_tutorial_embeded_link ?>" frameborder="0" allowfullscreen></iframe>
                        <div class="widget style1 black-bg" style="color:#fff">
                            <div class="row">
                                <div class="col-xs-12 text-left">
                                    <h3 class="font-bold" style="margin-bottom:5px">
                                        <?= $tutorial->support_tutorial_title ?>
                                    </h3>
                                    <span><?= $tutorial->support_tutorial_description ?><br></span>
                                    <div class="text-left">
                                        <br>
                                        <span><i class="fa fa-clock-o"></i> <?= date('g:i A - d-M-Y',strtotime($tutorial->support_tutorial_createdat)) ?></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; ?>
                        <?php else: ?>
                        <div class="alert alert-danger">
                            Maaf Tiada Data.
                        </div>
                        <?php endif; ?>

                        <?php  $pages = new Pagination($pages); ?>
                        <?php  echo LinkPager::widget([
                            'pagination' => $pages,
                        ]); ?>
                    </div>
                </div>
            </div>
        </div>
        <?=  $this->render('//layouts/_footer') ?>