<?php

use yii\helpers\Html;
use yii\grid\GridView;
use yii\widgets\Pjax;
use yii\helpers\BaseStringHelper;
use backend\models\Ref;
use backend\models\LayoutSkin;

/* @var $this yii\web\View */
/* @var $searchModel backend\models\support\SupportTutorialSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = Yii::t('app', 'Tutorial');
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="wrapper wrapper-content animated fadeInRight" style="padding: 20px 10px 0px;">
        <div class="row">
            <div class="col-lg-12">
                <div class="ibox float-e-margins">
                    <div class="ibox-content">
                            
            
                    <?= Html::a("<i class=\"glyphicon glyphicon-plus\"></i> " .Yii::t('app','Tambah')." Tutorial", ['create'], ['class' => 'btn btn-primary']) ?>
                    <br>
                
                    <?php Pjax::begin(); ?>

                    <?= GridView::widget([
                        
                'dataProvider' => $dataProvider,
                //'filterModel' => $searchModel,
                //'summary'   => '<p>{begin} - {end} daripada {totalCount} rekod</p>',
                'tableOptions' => 
                        [
                            'class' => 'table table-hover table-bordered',   
                        ],
                'options'=>['style' => 'text-align:center;'],
                'summary' => '',
                'columns' => [
                    ['class' => 'yii\grid\SerialColumn',
                     'headerOptions' => ['style' => 'text-align:center;'],
                     'contentOptions' => ['style' => 'text-align:center;'],
                    ],
                    // 'support_tutorial_id',
                    
                    ['attribute' => 'support_tutorial_description',
                    'headerOptions' => ['style' => 'text-align:center;'],
                    ],
                    [   
                        'attribute' => 'support_tutorial_embeded_link',
                        'headerOptions' => ['style' => 'text-align:center;'],
                        'contentOptions' => ['style' => 'text-align:center;width:40px'],
                        'value'     => function($model){
                            return BaseStringHelper::truncate($model->support_tutorial_embeded_link,100,'...');
                        }
                    ],
                    [
                        'label' => 'Peranan',
                        'headerOptions' => ['style' => 'text-align:center;'],
                        'contentOptions' => ['style' => 'text-align:center;'],
                        'value' =>  function($model)
                        {
                            $roles  = explode(",",$model->support_tutorial_role);
                            $rTrole = '';
                            foreach($roles as $role)
                            {   
                                if($role != "ALL")
                                {
                                    $rTrole .= $role." \n";
                                }else{
                                    $rTrole  .= "Semua Peranan \n";
                                }
                            }
                            return $rTrole;
                        }
                    ],
                    [   
                        'class' => 'yii\grid\ActionColumn',
                        'template' => '{view} {update} {delete}',
                        'headerOptions' => ['style' => 'text-align:center;'],
                        'contentOptions' => ['style' => 'text-align:center;width:95px'],
                        'header' => yii::t('app', 'Action'),
                        'buttons' =>[   
                                        'view' => function ($url, $model) 
                                        {
                                            return Html::a('<span style="margin:1px" class="glyphicon glyphicon-eye-open bigger-100"></span>', $url, [
                                                        'title' => Yii::t('app', 'View'),
                                            ]);
                                        },
                                        'update' => function ($url, $model) 
                                        {
                                            return Html::a('<span style="margin:1px" class="glyphicon glyphicon-pencil bigger-100"></span>', $url, [
                                                        'title' => Yii::t('app', 'Update'),
                                            ]);
                                        },
                                        'delete' => function ($url, $model)
                                        {
                                            return Html::a('<span style="margin:1px" class="glyphicon glyphicon-trash bigger-100"></span>', $url, [
                                                        'title' => Yii::t('app', 'Delete'), //'<span class="glyphicon glyphicon-search"></span>',
                                                        'onClick' => 'return doDelete()',
                                                        'data-method' => 'post'
                                            ]);
                                        },
                                    ]
                        ],
                ],
            ]); ?>
            <?php Pjax::end(); ?>
            
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>