<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use backend\models\LayoutSkin;

/* @var $this yii\web\View */
/* @var $model backend\models\support\SupportHelpdesk */

$this->title = $model->support_helpdesk_title;
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Support Helpdesks'), 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?><style>
    .ibox{
        margin-bottom:0px;
        margin-top:15px;
    }
    .spacer{
        padding:15px;
    }

    .clearfix::after{
        content:" ";
        height:0;
        display:block;
        clear:both;
    }
</style>
    <div class="ibox">
        <div class="ibox-title">
            <h2><?= $this->title; ?></h2>
        </div>
        <div class="ibox-content clearfix">
            <?= DetailView::widget([
                'model' => $model,
                'attributes' => [
                    [                      // the owner name of the model
                        'label' => Yii::t('app','Title'),
                        'value' => $model->support_helpdesk_title,
                    ],
                    [                      // the owner name of the model
                        'label' => Yii::t('app','Description'),
                        'format' => 'raw',
                        'value' => function($model) {
                            return '<pre>' . $model->support_helpdesk_description . '</pre>';
                        },
                    ],
                    [                      // the owner name of the model
                        'label' => Yii::t('app','Name'),
                        'value' => $model->support_helpdesk_name,
                    ],
                    [                      // the owner name of the model
                        'label' => Yii::t('app','Phone'),
                        'value' => $model->support_helpdesk_phone,
                    ],
                    [                      // the owner name of the model
                        'label' => Yii::t('app','Email'),
                        'value' => $model->support_helpdesk_email,
                    ],
                ],
            ]) ?>

            <?= Html::a('Kembali',['index'],['class'=>'btn btn-success btn-sm pull-right']); ?>
        </div>
    </div>
    <div class="spacer">&nbsp;</div>
<?= $this->render('//layouts/_footer.php');
