<?php

use yii\helpers\Html;
use yii\grid\GridView;
use backend\models\LayoutSkin;

/* @var $this yii\web\View */
/* @var $searchModel backend\models\support\SupportHelpdeskSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = Yii::t('app', 'Support Helpdesks');
$this->params['breadcrumbs'][] = $this->title;
?>
<style>
.clearfix::after { 
   content:'';
   display: block; 
   height: 0; 
   clear: both;
}
.ibox{
    margin-top:10px;
    margin-bottom:0px;
}
</style>
    <?php //echo $this->render('_search', ['model' => $searchModel]); ?>
    
   
    
    <div class="wrapper wrapper-content animated fadeInRight" style="padding: 0px 10px 0px;">
<div class="row">
                <div class="col-lg-12">
                    <div class="ibox float-e-margins">
                        <div class="ibox-title">
                            <h5><?= $this->title?></h5>
                        </div>
                        <div class="ibox-content">
                        <?=
                            GridView::widget([
                                'dataProvider' => $dataProvider,
                                'layout' => '{items} {pager}',
                                // 'filterModel' => $searchModel,
                                'tableOptions' => 
                                                [
                                                    'class' => 'table table-hover table-bordered',   
                                                ],
                                'options'=>['style' => 'text-align:center;'],
                                'summary' => '',
                                'columns' => [
                                    ['class' => 'yii\grid\SerialColumn',
                                        'header' => yii::t('app', 'No.'),
                                        'headerOptions' => ['style' => 'text-align:center;'],
                                        'contentOptions' => ['style' => 'width:10px;text-align:center;'],
                                    ],
                                    [   
                                        /* attribute for sorting */
                                        'attribute' => 'support_helpdesk_title',
                                        'label'     => yii::t('app', 'Title'),
                                        'headerOptions' => ['style' => 'text-align:center;'],
                                        'contentOptions' => ['style' => 'text-align:center;'],
                                        'format' => 'raw',
                                        'value' => function($model) {
                                            return $model->support_helpdesk_title;
                                        }
                                        
                                    ],
                                    [   
                                        /* attribute for sorting */
                                        'attribute' => 'support_helpdesk_name',
                                        'label'     => yii::t('app', 'Name'),
                                        'headerOptions' => ['style' => 'text-align:center;'],
                                        'contentOptions' => ['style' => 'text-align:center;'],
                                    ],
                                    [   
                                        /* attribute for sorting */
                                        'attribute' => 'support_helpdesk_email',
                                        'label'     => yii::t('app', 'Email'),
                                        'headerOptions' => ['style' => 'text-align:center;'],
                                        'contentOptions' => ['style' => 'text-align:center;'],
                                    ],
                                        [   
                                        /* attribute for sorting */
                                        'attribute' => 'support_helpdesk_phone',
                                        'label'     => yii::t('app', 'Phone'),
                                        'headerOptions' => ['style' => 'text-align:center;'],
                                        'contentOptions' => ['style' => 'text-align:center;'],
                                    ],
                                    [   
                                        'attribute' => 'support_helpdesk_description',
                                        'label'     => yii::t('app', 'Description'),
                                        'headerOptions' => ['style' => 'text-align:center;'],
                                        'contentOptions' => ['style' => 'text-align:center;'],
                                        'format' => 'raw',
                                        'value' => function($model) {
                                            return $model->support_helpdesk_description;
                                        }
                                        
                                    ],
                                    [   'class' => 'yii\grid\ActionColumn',
                                        'template' => '{view} {delete}',
                                        'header' => yii::t('app', 'Action'),
                                        'headerOptions' => ['style' => 'text-align:center;'],
                                        'contentOptions' => ['style' => 'text-align:center;'],
                                        'buttons' => [
                                                'view' => function ($url, $model) {
                                                return Html::a('<span style="margin:1px" class="glyphicon glyphicon-eye-open bigger-100"></span>', $url, [
                                                            'title' => Yii::t('app', 'Papar'),
                                                ]);
                                            },
                                                'delete' => function ($url, $model) {
                                                return Html::a('<span style="margin:1px" class="glyphicon glyphicon-trash bigger-100"></span>', $url, [
                                                            'title' => Yii::t('app', 'Hapus'), //'<span class="glyphicon glyphicon-search"></span>',
                                                            'onClick' => 'return doDelete()',
                                                            'data-method' => 'post'
                                                ]);
                                            },
                                                
                                        ]],
                                    ],
                                ]);
                        ?>
                </div>
            </div>
        </div>
    </div>
</div>


<?= $this->render('//layouts/_footer'); ?>



</div>
