    <?php

use yii\helpers\Html;
use yii\grid\GridView;
use yii\helpers\BaseStringHelper;
use backend\models\Ref;

/* @var $this yii\web\View */
/* @var $searchModel backend\models\support\SupportFaqSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = Yii::t('app', 'Support Faqs');
$this->params['breadcrumbs'][] = $this->title;
?>
<style>
.rbtn{
    /* display:inline; */
    margin-bottom:10px;
}
.title{
    display:inline;
}
</style>
        
<div class="wrapper wrapper-content animated fadeInRight">
    <p>
        <?= Html::a("<i class=\"glyphicon glyphicon-plus\"></i> " .Yii::t('app', 'Cipta Soalan/Jawapan'), ['create'], ['class' => 'btn btn-primary']) ?>
</p></p>

    <div class="row">
        <div class="col-lg-12 animated fadeInRight">
            <div class="ibox">
                <div class="mail-box b-r-md">
                        <?= GridView::widget([
                            'dataProvider' => $dataProvider,
                            'tableOptions' => ['class' => 'table'],
                            //'filterModel' => $searchModel,
                            //'summary' => '<p>{begin} - {end} daripada {totalCount} rekod</p>',
                            'options'=>['style' => 'text-align:center;'],
                            'summary' => '',
                            'columns' => [
                                ['class' => 'yii\grid\SerialColumn'],
                                [
                                  'attribute' => 'support_faq_title',
                                  'headerOptions' => ['style' => 'text-align:center;'],
                                  'contentOptions' => ['style' => 'text-align:center;'],
                                  
                                ],
                                [
                                  'attribute' => 'support_faq_description',
                                  'headerOptions' => ['style' => 'text-align:center;'],
                                  //'contentOptions' => ['style' => 'text-align:center;'],
                                  
                                ],
                                [
                                  'attribute' => 'support_faq_question',
                                  'headerOptions' => ['style' => 'text-align:center;'],
                                  
                                ],
                                [   
                                    'attribute' => 'support_faq_answer',
                                    'headerOptions' => ['style' => 'text-align:center;'],
                                    'label' => 'Jawapan',
                                    'value' => function($model)
                                    {
                                        return BaseStringHelper::truncate($model->support_faq_answer,100,'...');
                                    }
                                ],
                                [
                                 'headerOptions' => ['style' => 'text-align:center;'],
                                 'contentOptions' => ['style' => 'text-align:center;'],
                                 'format' => 'raw',
                                 'value'=> function ($model)
                                 {
                                     $roles = explode(",",$model->support_faq_role);
                                     $roles = implode(" | ", $roles);
                                     

                                     return "<pre>" . $roles . "</pre>";
                                 },
                                 'header'=> 'Peranan'
                                //'headerOptions' => ['style' => 'text-align:center;'],
                                ],
                                // 'support_faq_createdat',
                                // 'support_faq_createdby',
                                // 'support_faq_updatedat',
                                // 'support_faq_updatedby',

                                [   
                                'class' => 'yii\grid\ActionColumn',
                                'template' => '{view} {update} {delete}',
                                'contentOptions' => ['style' => 'width:95px;text-align:center;'],
                                'header' => yii::t('app', 'Action'),
                                'headerOptions' => ['style' => 'text-align:center;'],
                                'buttons' =>[   
                                                'view' => function ($url, $model) 
                                                {
                                                    return Html::a('<span style="margin:1px" class="glyphicon glyphicon-eye-open bigger-100"></span>', $url, [
                                                                'title' => Yii::t('app', 'View'),
                                                    ]);
                                                },
                                                'update' => function ($url, $model) 
                                                {
                                                    return Html::a('<span style="margin:1px" class="glyphicon glyphicon-pencil bigger-100"></span>', $url, [
                                                                'title' => Yii::t('app', 'Update'),
                                                    ]);
                                                },
                                                'delete' => function ($url, $model)
                                                {
                                                    return Html::a('<span style="margin:1px" class="glyphicon glyphicon-trash bigger-100"></span>', $url, [
                                                                'title' => Yii::t('app', 'Delete'), //'<span class="glyphicon glyphicon-search"></span>',
                                                                'onClick' => 'return doDelete()',
                                                                'data-method' => 'post'
                                                    ]);
                                                },
                                            ]
                                ],
                            ],
                        ]); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>