<?php

namespace backend\modules\support\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\modules\support\models\SupportTutorial;

/**
 * SupportTutorialSearch represents the model behind the search form about `backend\models\support\SupportTutorial`.
 */
class SupportTutorialSearch extends SupportTutorial
{   

    /**
     * @param array $roles
     */
    public $roles;

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['support_tutorial_id', 'support_tutorial_createdby', 'support_tutorial_updatedby'], 'integer'],
            [['support_tutorial_title', 'support_tutorial_description', 'support_tutorial_embeded_link', 'support_tutorial_role', 'support_tutorial_createdat', 'support_tutorial_updatedat'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = SupportTutorial::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'pagination' => 
                [
                    'pageSize' => 5,
                ],
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            return $dataProvider;
        }
        /* Reiterate every roles assign to this user  */
        if(!empty($this->roles) && is_array($this->roles))
        {
            foreach ($this->roles as $role)
            {
                $query->orFilterWhere(['like', 'support_tutorial_role', $role]);
                $query->orFilterWhere(['like', 'support_tutorial_role', 'ALL']);
            }
        }
        // grid filtering conditions
        $query->andFilterWhere([
            'support_tutorial_id' => $this->support_tutorial_id,
            'support_tutorial_createdat' => $this->support_tutorial_createdat,
            'support_tutorial_createdby' => $this->support_tutorial_createdby,
            'support_tutorial_updatedat' => $this->support_tutorial_updatedat,
            'support_tutorial_updatedby' => $this->support_tutorial_updatedby,
        ]);

        $query->andFilterWhere(['like', 'support_tutorial_title', $this->support_tutorial_title])
            ->andFilterWhere(['like', 'support_tutorial_description', $this->support_tutorial_description])
            ->andFilterWhere(['like', 'support_tutorial_embeded_link', $this->support_tutorial_embeded_link])
            ->andFilterWhere(['like', 'support_tutorial_role', $this->support_tutorial_role]);

        return $dataProvider;
    }
}
