<?php

namespace backend\modules\support\models;
use yii\behaviors\TimestampBehavior;
use yii\behaviors\BlameableBehavior;
use Yii;
use yii\db\ActiveRecord;
use yii\db\Expression;
use backend\models\Ref;
use yii\data\Pagination;
use backend\models\Staff;
/**
 * This is the model class for table "support_tutorial".
 *
 * @property integer $support_tutorial_id
 * @property string $support_tutorial_title
 * @property string $support_tutorial_description
 * @property string $support_tutorial_embeded_link
 * @property string $support_tutorial_role
 * @property string $support_tutorial_createdat
 * @property integer $support_tutorial_createdby
 * @property string $support_tutorial_updatedat
 * @property integer $support_tutorial_updatedby
 */
class SupportTutorial extends \yii\db\ActiveRecord
    
{

    public function behaviors(){
        return 
        [
            // [
            //     'class' => TimestampBehavior::className(),
            //     'attributes' => [
            //         ActiveRecord::EVENT_BEFORE_INSERT => ['support_tutorial_createdat', 'support_tutorial_updatedat'],
            //         ActiveRecord::EVENT_BEFORE_UPDATE => ['support_tutorial_updatedat'],
            //     ],                
            // ],
            [
                'class' => BlameableBehavior::className(),
                'createdByAttribute' => 'support_tutorial_createdby',
                'updatedByAttribute' => 'support_tutorial_updatedby'
            ],
        ];
    }
    /** 
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'support_tutorial';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['support_tutorial_title', 'support_tutorial_description', 'support_tutorial_embeded_link'], 'string'],
            [['support_tutorial_title', 'support_tutorial_description', 'support_tutorial_embeded_link','support_tutorial_role'], 'required'],
            [['support_tutorial_createdat', 'support_tutorial_updatedat'], 'safe'],
            [['support_tutorial_createdby', 'support_tutorial_updatedby'], 'integer'],
            // [['support_tutorial_embeded_link'], 'url','message'=>'Maklumat pautan yang tidak sah'],
            [['support_tutorial_embeded_link'], 
            function($attribute){
                $arr = array();
                preg_match('/https:\/\/(www\.youtube\.com\/embed\/)/i',$this->support_tutorial_embeded_link,$arr);
                if(isset($arr[1]) && $arr[1] === "www.youtube.com/embed/")
                {
                    return true;
                }else{
                    $this->addError($attribute, 'Pautan tidak sah.');
                }
            }]
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'support_tutorial_id' => Yii::t('app', 'Support Tutorial ID'),
            'support_tutorial_title' => Yii::t('app', 'Title'),
            'support_tutorial_description' => Yii::t('app', 'Description'),
            'support_tutorial_embeded_link' => Yii::t('app', 'Embeded Link'),
            'support_tutorial_role' => Yii::t('app', 'Role'),
            'support_tutorial_createdat' => Yii::t('app', 'Di Cipta pada'),
            'support_tutorial_createdby' => Yii::t('app', 'Di Cipta Oleh'),
            'support_tutorial_updatedat' => Yii::t('app', 'Di Kemaskini pada'),
            'support_tutorial_updatedby' => Yii::t('app', 'Di Kemaskini Oleh'),
        ];
    }

    public function getRole()
    {
       return $this->hasOne(Ref::className(),['code' =>'support_tutorial_role']);
    }
    
    public function beforeSave($insert)
    {
        if (parent::beforeSave($insert)) {
            if($insert)
            {
                $this->support_tutorial_createdby = Yii::$app->user->id;
                $this->support_tutorial_createdat = date('Y-m-d H:i:s');
            }else{
                $this->support_tutorial_updatedat = date('Y-m-d H:i:s');
                $this->support_tutorial_updatedby = Yii::$app->user->id;
            }
            return true;
        } else {
            return false;
        }
    }

    public function getUser()
    {
        return $this->hasOne(Staff::classname(),["userid"=>"support_tutorial_createdby"]);
    }
}
