<?php

namespace backend\modules\support\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\modules\support\models\SupportHelpdesk;

/**
 * SupportHelpdeskSearch represents the model behind the search form about `backend\models\support\SupportHelpdesk`.
 */
class SupportHelpdeskSearch extends SupportHelpdesk
{
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['support_helpdesk_id'], 'integer'],
            [['support_helpdesk_title', 'support_helpdesk_description', 'support_helpdesk_name', 'support_helpdesk_role', 'support_helpdesk_section','support_helpdesk_subsection', 'support_helpdesk_phone', 'support_helpdesk_email', 'support_helpdesk_createdat', 'support_helpdesk_createdby'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = SupportHelpdesk::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'pagination' => [
                'pageSize' => 5,
                ],
            'sort' => ['attributes' => ['support_helpdesk_title','support_helpdesk_description','support_helpdesk_section','support_helpdesk_subsection']],
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'support_helpdesk_id' => $this->support_helpdesk_id,
        ]);

        $query->andFilterWhere(['like', 'support_helpdesk_title', $this->support_helpdesk_title])
            ->andFilterWhere(['like', 'support_helpdesk_description', $this->support_helpdesk_description])
            ->andFilterWhere(['like', 'support_helpdesk_name', $this->support_helpdesk_name])
            ->andFilterWhere(['like', 'support_helpdesk_role', $this->support_helpdesk_role])
            ->andFilterWhere(['like', 'support_helpdesk_section', $this->support_helpdesk_section])
            ->andFilterWhere(['like', 'support_helpdesk_subsection', $this->support_helpdesk_subsection])
            ->andFilterWhere(['like', 'support_helpdesk_phone', $this->support_helpdesk_phone])
            ->andFilterWhere(['like', 'support_helpdesk_email', $this->support_helpdesk_email])
            ->andFilterWhere(['like', 'support_helpdesk_createdat', $this->support_helpdesk_createdat])
            ->andFilterWhere(['like', 'support_helpdesk_createdby', $this->support_helpdesk_createdby]);

        return $dataProvider;
    }
}
