<?php

namespace backend\modules\support\models;

use Yii;
use yii\behaviors\TimestampBehavior;
use yii\db\ActiveRecord;
use yii\behaviors\BlameableBehavior;
use backend\models\Ref;
/**
 * This is the model class for table "support_helpdesk".
 *
 * @property integer $support_helpdesk_id
 * @property string $support_helpdesk_title
 * @property string $support_helpdesk_description
 * @property string $support_helpdesk_name
 * @property string $support_helpdesk_role
 * @property string $support_helpdesk_section
 * @property string $support_helpdesk_subsection
 * @property string $support_helpdesk_phone
 * @property string $support_helpdesk_email
 * @property string $support_helpdesk_createdat
 * @property string $support_helpdesk_createdby
 */
class SupportHelpdesk extends \yii\db\ActiveRecord
{   
    public function behaviors()
    {
        return 
        [
            [
                'class' => TimestampBehavior::className(),
                'attributes' => [
                    ActiveRecord::EVENT_BEFORE_INSERT => ['support_helpdesk_createdat'],
                    // ActiveRecord::EVENT_BEFORE_UPDATE => ['updated_at'],
                ],
            ],
            [
                'class' => BlameableBehavior::className(),
                'createdByAttribute' => 'support_helpdesk_createdby',
                'updatedByAttribute' => 'support_helpdesk_createdby',
            ],
        ];
    }

    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'support_helpdesk';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['support_helpdesk_title', 'support_helpdesk_description', 'support_helpdesk_name', 'support_helpdesk_phone', 'support_helpdesk_email', 'support_helpdesk_createdat', 'support_helpdesk_createdby'], 'string'],
            [['support_helpdesk_title', 'support_helpdesk_description', 'support_helpdesk_name', 'support_helpdesk_phone', 'support_helpdesk_email'], 'required'],
            [['support_helpdesk_role'], 'safe']
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'support_helpdesk_id' => Yii::t('app', 'Support Helpdesk ID'),
            'support_helpdesk_title' => Yii::t('app', 'Tajuk'),
            'support_helpdesk_description' => Yii::t('app', 'Diskripsi'),
            'support_helpdesk_name' => Yii::t('app', 'Nama'),
            'support_helpdesk_subsection' => Yii::t('app', 'Sub Kategori'),
            'support_helpdesk_section' => Yii::t('app', 'Kategori'),
            'support_helpdesk_role' => Yii::t('app', 'Peranan'),
            'support_helpdesk_phone' => Yii::t('app', 'Telefon'),
            'support_helpdesk_email' => Yii::t('app', 'Emel'),
            'support_helpdesk_createdat' => Yii::t('app', 'Support Helpdesk Createdat'),
            'support_helpdesk_createdby' => Yii::t('app', 'Support Helpdesk Createdby'),
        ];
    }

    public function getRole()
    {
        return $this->hasOne(Ref::className(),['code'=>'support_helpdesk_role'])->andWhere(['cat'=>'ROLE']);
    }
    
    public function beforeSave($insert)
    {
        if (parent::beforeSave($insert)) {
            if($insert)
            {
                $this->support_helpdesk_createdby = Yii::$app->user->id;
                $this->support_helpdesk_createdat = date('Y-m-d H:i:s');
            }
            return true;
        } else {
            return false;
        }
    }
}
