<?php

namespace backend\modules\support\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use yii\data\ArrayDataProvider;
use backend\modules\support\models\SupportFaq;

/**
 * SupportFaqSearch represents the model behind the search form about `backend\models\support\SupportFaq`.
 */
class SupportFaqSearch extends SupportFaq
{
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['support_faq_id'], 'integer'],
            [['support_faq_title', 'support_faq_description', 'support_faq_question', 'support_faq_answer', 'support_faq_role', 'support_faq_createdat', 'support_faq_createdby', 'support_faq_updatedat', 'support_faq_updatedby'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = SupportFaq::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'support_faq_id' => $this->support_faq_id,
        ]);

        $query->andFilterWhere(['like', 'support_faq_title', $this->support_faq_title])
            ->andFilterWhere(['like', 'support_faq_description', $this->support_faq_description])
            ->andFilterWhere(['like', 'support_faq_question', $this->support_faq_question])
            ->andFilterWhere(['like', 'support_faq_answer', $this->support_faq_answer])
            ->andFilterWhere(['like', 'support_faq_role', $this->support_faq_role])
            ->andFilterWhere(['like', 'support_faq_createdat', $this->support_faq_createdat])
            ->andFilterWhere(['like', 'support_faq_createdby', $this->support_faq_createdby])
            ->andFilterWhere(['like', 'support_faq_updatedat', $this->support_faq_updatedat])
            ->andFilterWhere(['like', 'support_faq_updatedby', $this->support_faq_updatedby]);

        return $dataProvider;
    }
}
