<?php

namespace backend\modules\support\models;
use backend\models\ref;
use Yii;

/**
 * This is the model class for table "support_faq".
 *
 * @property integer $support_faq_id
 * @property string $support_faq_title
 * @property string $support_faq_description
 * @property string $support_faq_question
 * @property string $support_faq_answer
 * @property string $support_faq_role
 * @property string $support_faq_createdat
 * @property string $support_faq_createdby
 * @property string $support_faq_updatedat
 * @property string $support_faq_updatedby
 */
class SupportFaq extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'support_faq';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['support_faq_title', 'support_faq_description', 'support_faq_question', 'support_faq_createdat', 'support_faq_createdby', 'support_faq_updatedat', 'support_faq_updatedby'], 'string'],
            [['support_faq_title','support_faq_answer', 'support_faq_description', 'support_faq_question', 'support_faq_role'], 'required'],
            [['support_faq_answer'], 'string', 'max' => 1000],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'support_faq_id' => Yii::t('app', 'Support Faq ID'),
            'support_faq_title' => Yii::t('app', 'Title'),
            'support_faq_description' => Yii::t('app', 'Description'),
            'support_faq_question' => Yii::t('app', 'Question'),
            'support_faq_answer' => Yii::t('app', 'Answer'),
            'support_faq_role' => Yii::t('app', 'Role'),
            'support_faq_createdat' => Yii::t('app', 'Support Faq Createdat'),
            'support_faq_createdby' => Yii::t('app', 'Support Faq Createdby'),
            'support_faq_updatedat' => Yii::t('app', 'Support Faq Updatedat'),
            'support_faq_updatedby' => Yii::t('app', 'Support Faq Updatedby'),
        ];
    }

    public function getRole()
    {
        // return $this->hasOne(ref::className(),['code'=>'support_faq_role'])->andWhere(['cat'=>'ROLE']);    
    }

    public function beforeSave($insert)
    {
        if (parent::beforeSave($insert)) {
            if($insert)
            {
                $this->support_faq_createdby = Yii::$app->user->id;
                $this->support_faq_createdat = date('Y-m-d H:i:s');
            }else{
                $this->support_faq_updatedat = date('Y-m-d H:i:s');
                $this->support_faq_updatedby = Yii::$app->user->id;
            }
            return true;
        } else {
            return false;
        }
    }
}
