<?php   

namespace backend\modules\support\controllers;

use Yii;
use backend\modules\support\models\SupportTutorial;
use backend\modules\support\models\SupportTutorialSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;
use common\components\AccessRule;

/**
 * SupportTutorialController implements the CRUD actions for SupportTutorial model.
 */
class SupportTutorialController extends Controller
{
    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'ruleConfig' => [
                    'class' => AccessRule::className(),
                ],
                'rules' => [
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all SupportTutorial models.
     * @return mixed
     */
    public function actionIndex()
    {   
        $searchModel = new SupportTutorialSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single SupportTutorial model.
     * @param integer $id
     * @return mixed
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new SupportTutorial model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new SupportTutorial();
        if ($model->load(Yii::$app->request->post())) 
        {   
            /* set peranan */
            if (is_array($model->support_tutorial_role)) {
                $model->support_tutorial_role = implode(',',Yii::$app->request->post('SupportTutorial')['support_tutorial_role']);
            }
            
            $url = array();
            /* select only src tag */
            if( preg_match('/src="([^"]*)"/i',$model->support_tutorial_embeded_link,$arr) )
            {   
                $model->support_tutorial_embeded_link = $arr[1];
            }

            if($model->save())
            {
                 return $this->redirect(['view', 'id' => $model->support_tutorial_id]);
            }else{
                return $this->render('create', [
                    'model' => $model,
                ]);
            }
        } else {
            return $this->render('create', [
                'model' => $model,
            ]);
        }
    }

    /* views for all tutorials */
    public function actionViewTutorial()
    {   
        $model = new SupportTutorialSearch;
        //$model->roles = Yii::$app->user->identity->usrroles;
        $dataprovider = $model->search(Yii::$app->request->queryParams);
        
        $count  = $dataprovider->getCount();
        $tCount = $dataprovider->getTotalCount();

        // echo '<pre>'; var_dump( $count ); echo '</pre>';die();

        return $this->render('view-tutorial',
            [
                'model' => $dataprovider->getModels(),
                'pages' => [
                    'pageSize' => $count,
                    'totalCount'    => $tCount
                ],
            ]
        );
    }

    /** 
     * Updates an existing SupportTutorial model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);
        
        if ($model->load(Yii::$app->request->post())) 
        {
             /* set peranan */
            $model->support_tutorial_role = implode(',',Yii::$app->request->post('SupportTutorial')['support_tutorial_role']);
            $url = array();
            /* select only src tag */
            if( preg_match('/src="([^"]*)"/i',$model->support_tutorial_embeded_link,$arr) )
            {   
                $model->support_tutorial_embeded_link = $arr[1];
            }
            if($model->save())
            {
                return $this->redirect(['view', 'id' => $model->support_tutorial_id]);
            }else{
                return $this->render('update', [
                    'model' => $model,
                ]);
            }
        } else {
            return $this->render('update', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Deletes an existing SupportTutorial model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the SupportTutorial model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return SupportTutorial the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = SupportTutorial::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
    
}


