<?php

namespace backend\modules\support\controllers;

use Yii;
use backend\modules\support\models\SupportFaq;
use backend\modules\support\models\SupportFaqSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;
use common\components\AccessRule;

/**
 * SupportFaqController implements the CRUD actions for SupportFaq model.
 */
class SupportFaqController extends Controller
{
    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'ruleConfig' => [
                    'class' => AccessRule::className(),
                ],
                'rules' => [
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                    'viewAll' => ['GET'],
                ],
            ],
        ];
    }

    /**
     * Lists all SupportFaq models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new SupportFaqSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single SupportFaq model.
     * @param integer $id
     * @return mixed
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Displays a All SupportFaq model.
     * @param integer $id
     * @return mixed
     */
     public function actionViewsFaq()
     {  
         return $this->render('views-faq',
        [
            "model" => SupportFaqSearch::find()->all()
        ]);
     }

    /**
     * Creates a new SupportFaq model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new SupportFaq();

        if ($model->load(Yii::$app->request->post())) {
            
            $model->support_faq_role = implode(',',Yii::$app->request->post('SupportFaq')['support_faq_role']);

            if($model->save())
            {
                return $this->redirect(['view', 'id' => $model->support_faq_id]);
            }else{
                return $this->render('create', [
                    'model' => $model,
                ]);
            }

        } else {
            return $this->render('create', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Updates an existing SupportFaq model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);
        
        if ($model->load(Yii::$app->request->post()) ) {
            $model->support_faq_role = implode(',',Yii::$app->request->post('SupportFaq')['support_faq_role']);
            if($model->save())
            {
                return $this->redirect(['view', 'id' => $model->support_faq_id]);
            }else{
                return $this->render('create', [
                    'model' => $model,
                ]);
            }
        } else {
            return $this->render('update', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Deletes an existing SupportFaq model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the SupportFaq model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return SupportFaq the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = SupportFaq::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }

    public function actionStub()
    {
       return $this->render('stub');
    }
}
