<?php

use yii\helpers\Html;
use yii\grid\GridView;
use yii\widgets\Pjax;

/* @var $this yii\web\View */
/* @var $searchModel backend\models\RefSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = Yii::t('app', 'Parameter');
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="ref-index">
    <div class="wrapper wrapper-content animated fadeInRight">

        <p>
            <?= Html::a(Yii::t('app', 'Add') . ' ' . Yii::t('app', 'Parameter'), ['ref/create'], ['class' => 'btn btn-primary']) ?>
        </p>

        <div class="ibox">
            <?php Pjax::begin(); ?>
            <div class="mail-box b-r-md">
                <div class="table-responsive">
                    <?=
                    GridView::widget([
                        'dataProvider' => $dataProvider,
                        'filterModel' => $searchModel,
                        'tableOptions' => ['class' => 'table'],
                        'summary' => '',
                        'columns' => [
                            ['class' => 'yii\grid\SerialColumn'],
                            // 'id',
                            'cat',
                            'code',
                            'descr',
                            'descr_en',
                            [
                                'attribute' => 'param1',
                                'value' => function($model) {
                                    return $model->getdescr($model->param1);
                                }
                            ],
                            //'icon_name',
                            //'created_by',
                            //'created_at',
                            //'updated_by',
                            //'updated_at',
                            //'deleted_at',
                            //'descr_my',
                            //'descr_en',
                            [
                                'class' => 'yii\grid\ActionColumn',
                                'contentOptions' => ['class' => 'text-center', 'width' => '10%'],
                                'template' => '{view} {update} {delete}'
                            ],
                        ],
                    ]);
                    ?>
                    <?php Pjax::end(); ?>
                </div>
            </div>
        </div>
    </div>
</div>



