<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;

/* @var $this yii\web\View */
/* @var $model backend\models\RefSearch */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="ref-search">

    <?php $form = ActiveForm::begin([
        'action' => ['index'],
        'method' => 'get',
        'options' => [
            'data-pjax' => 1
        ],
    ]); ?>
    
    <div class="col-md-8">
        <div class="row">
        
            <?= $form->field($model, 'cat',['options'=>['class' => 'col-md-6']])->textInput(['placeholder'=> Yii::t('app','Category')])->label(false)  ?>

            <?= $form->field($model, 'code',['options'=>['class' => 'col-md-6']])->textInput(['placeholder'=> Yii::t('app','Code')])->label(false)  ?>
        
        </div>

    </div>


    <div class="form-group col-md-4">
        <?= Html::submitButton('<i class="fa fa-search"></i> '.Yii::t('app', 'Cari'), ['class' => 'btn btn-default']) ?>
        <?= Html::resetButton('<i class="fa fa-refresh"></i> '.Yii::t('app', 'Semula'), ['class' => 'btn btn-default']) ?> | 
        <?= Html::a(Yii::t('app', 'Add Categori'),['ref/create'], ['class' => 'btn btn-primary']) ?>
    </div>

    <?php ActiveForm::end(); ?>
    <div class="clearfix"></div>
</div>
