<?php

namespace backend\modules\refdynawebv2\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;

/**
 * RefSearch represents the model behind the search form about `app\models\Ref`.
 */
class RefSearch extends Ref
{
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['id', 'sort'], 'integer'],
            [['cat', 'code', 'descr', 'param1'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }
    
    public function search2($params)
    { 
        $mRef = Ref::findOne($_GET['id']);
        $query = Ref::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'sort'=> ['defaultOrder' => ['sort' => SORT_ASC]],
            'pagination' => [ 'pageSize' => 200 ],
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'sort' => $this->sort,
        ]);
        
        if($_GET['cat'] == 'dae') {
            $query->andFilterWhere(['=', 'cat', 'mkm'])
                ->andFilterWhere(['like', 'code', $this->code])
                ->andFilterWhere(['like', 'descr', $this->descr])
                ->andFilterWhere(['like', 'param1', $mRef->id]);
        } else {
            $query->andFilterWhere(['=', 'cat', 'dun'])
                ->andFilterWhere(['like', 'code', $this->code])
                ->andFilterWhere(['like', 'descr', $this->descr])
                ->andFilterWhere(['like', 'param1', $mRef->id]);
        }

        return $dataProvider;
    }
    
    public function search3($params)
    { 
        $mRef = Ref::findOne($_GET['id']);
        $query = Ref::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'sort'=> ['defaultOrder' => ['sort' => SORT_ASC]],
            'pagination' => [ 'pageSize' => 200 ],
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'sort' => $this->sort,
        ]);
        
        $query->andFilterWhere(['=', 'cat', 'SUBETHNIC'])
                ->andFilterWhere(['like', 'code', $this->code])
                ->andFilterWhere(['like', 'descr', $this->descr])
                ->andFilterWhere(['like', 'param1', $mRef->id]);

        return $dataProvider;
    }
    
        public function search4($params)
    {
        $query = Ref::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'sort'=> ['defaultOrder' => ['sort' => SORT_ASC]],
        ]);
        
        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'sort' => $this->sort,
        ]);

        $query->andFilterWhere(['like', 'cat', $this->cat])
            ->andFilterWhere(['like', 'code', $this->code])
            ->andFilterWhere(['like', 'descr', $this->descr])
            ->andFilterWhere(['like', 'param1', $this->param1]);

        return $dataProvider;
    }

    public function search($params)
    {
        $query = Ref::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'sort'=> ['defaultOrder' => ['sort' => SORT_ASC]],
        ]);
        
        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'sort' => $this->sort,
        ]);

        $query->andFilterWhere(['like', 'cat', 'ROLE'])
            ->andFilterWhere(['like', 'code', $this->code])
            ->andFilterWhere(['like', 'descr', $this->descr])
            ->andFilterWhere(['like', 'param1', $this->param1]);

        return $dataProvider;
    }
    
    public function searchCtyParList($params)
    {
        $mRef = Ref::findOne($_GET['id']);
        $query = Ref::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'sort'=> ['defaultOrder' => ['sort' => SORT_ASC]],
            'pagination' => [ 'pageSize' => 200 ],
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'sort' => $this->sort,
        ]);

        $query->andFilterWhere(['=', 'cat', 'CTYPAR'])
            ->andFilterWhere(['like', 'code', $this->code])
            ->andFilterWhere(['like', 'descr', $this->descr])
            ->andFilterWhere(['like', 'param1', $this->param1]);

        return $dataProvider;
    }
    
    public function searchListData($params)
    {
        $mRef = Ref::findOne($_GET['id']); 
        $query = Ref::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'sort'=> ['defaultOrder' => ['sort' => SORT_ASC]],
            'pagination' => [ 'pageSize' => 200 ],
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }
        
        if($_GET['cat'] == 'dae') {
            $query->andWhere('cat="dae"');
        } else {
            $query->andWhere('cat="par"');
        }
        
        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'sort' => $this->sort,
        ]);

        $query->andFilterWhere(['like', 'cat', $this->cat])
            ->andFilterWhere(['like', 'code', $this->code])
            ->andFilterWhere(['like', 'descr', $this->descr])
            ->andFilterWhere(['=', 'param1', $mRef->id]);

        return $dataProvider;
    }
}
