<?php

namespace backend\modules\refdynawebv2\models;

use Yii;
use common\models\Dermaga;

/**
 * This is the model class for table "ost_ref".
 *
 * @property integer $id
 * @property string $cat
 * @property string $code
 * @property string $descr
 * @property integer $sort
 * @property string $param1
 */
class Ref extends Dermaga {

    /**
     * @inheritdoc
     */
    public static function tableName() {
        return 'ref';
    }

    /**
     * @inheritdoc
     */
    public function rules() {
        return [
            [['sort'], 'integer'],
            [['code', 'cat'], 'required'],
            [['created_at', 'updated_at', 'deleted_at'], 'safe'],
            [['cat', 'code'], 'string', 'max' => 25],
            [['descr'], 'string', 'max' => 150],
            [['param1'], 'string', 'max' => 5],
            [['icon_name'], 'string', 'max' =>50],
            [['created_by', 'updated_by'], 'string', 'max' => 50],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels() {
        return [
            'id' => 'ID',
            'cat' => Yii::t('app','Category'),
            'code' => Yii::t('app','Code'),
            'descr' => Yii::t('app','Description'),
            'sort' => Yii::t('app','Order'),
            'param1' => Yii::t('app','Parent'),
            'created_at' => Yii::t('app','Created Date'),
        ];
    }

    public static function getList($kat, $param1 = '', $choose = true, $sort = 'descr,sort') {
        $arr2 = [];

        if ($choose) {
            // $arr2['0'] = '--Sila Pilih--';
        }

        if (empty($param1)) {
            $arr = self::find()->where("cat = '$kat'")->orderBy($sort)->all();
        } else {
            $arr = self::find()->where("cat = '$kat' AND param1 = '$param1'")->orderBy('descr,sort')->all();
        }

        foreach ($arr as $param) {
            $arr2[$param->code] = $param->descr;
        }
        return $arr2;
    }

    public static function getList2($kat, $code = "", $choose = true) {
        $arr2 = [];

        if ($choose) {
            // $arr2['0'] = '--Sila Pilih--';
        }

        if (empty($code)) {
            $arr = self::find()->where("cat = '$kat'")->orderBy('sort,descr')->all();
        } else {
            $arr = self::find()->where("cat = '$kat' AND code IN ($code)")->orderBy('sort,descr')->all();
        }

        foreach ($arr as $code) {
            $arr2[$code->code] = $code->descr;
        }
        return $arr2;
    }

    public static function getDesc($cat, $code, $field = '') {
        $ref = self::find()->where(['cat' => $cat, 'code' => $code])->one();
        if (!is_null($ref)) {
            if ($field)
                return $ref->$field;
            else
                return $ref->descr; 
        } else {
            return '';
        }
    }

    public function parent(){
        $ref = self::find()->where(['param1' => NULL ])->andWhere(['!=','cat' ,'NEG'])->all();
        $refarr = [];
        array_walk($ref,function($v) use (&$refarr){
            return $refarr[$v->code] = $v->descr;
        });

        return $refarr;
    }


    public function getSoalanParlimen() {
        return $this->hasMany(\backend\models\SoalanParlimen::className(), ['kat_dewan' => 'code']);
    }
}
