<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use backend\modules\publicationDocument\Module as M;

/* @var $this yii\web\View */
/* @var $model backend\modules\publicationDocument\models\PublicationVersion */

$this->title = $model->version_id;
$this->params['breadcrumbs'][] = ['label' => M::t('app', 'Check'), 'url' => ['check']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
?>
<div class="wrapper wrapper-content animated fadeInRight">
    <div class="ibox float-e-margins">
        <div class="ibox-content">
            <div class="publication-version-view">

    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
            'document_id',
            'version_no',
            'version_language',
            'version_main',
            'version_status',
            'version_title',
            'version_content',
            'version_date_start',
            'version_date_end',
            'approval_status',
        ],
    ]) ?>

    <div class="row">
      <?= Html::a(M::t('app', 'Kembali'), ['#'], [ 'class' => 'btn btn-warning', 'onclick' => "window.history.go(-1); return false;"]) ?>
            <?php if ($model->approval_status == 'appStatus01') { ?>
                <?= Html::a(M::t('app', 'Approve'), ['approve', 'id' => $model->version_id], ['class' => 'btn btn-primary']) ?>
                <?= Html::a(M::t('app', 'Reject'), ['reject', 'id' => $model->version_id], [ 'class' => 'btn btn-danger']) ?>
            <?php } ?>
    </div>
  
            </div>
        </div>
    </div>
</div>

