<?php

use yii\helpers\Html;
use yii\grid\GridView;
use yii\helpers\ArrayHelper;
use backend\modules\publicationDocument\Module as M;

/* @var $this yii\web\View */
/* @var $searchModel backend\modules\publicationDocument\models\PublicationVersionSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = M::t('app', 'Version');
$this->params['breadcrumbs'][] = ['label' => M::t('app', 'Document'), 'url' => ['publication-document/index']];
$this->params['breadcrumbs'][] = $this->title;

    switch(Yii::$app->language){
        case 'en':
            $desc = 'descr_en';
            break;
        default:
            $desc = 'descr';
            break;
    }

    $request = Yii::$app->request->get('document_id');
?>
<div class="wrapper wrapper-publication">
    <p>
        <?= Html::a(M::t('app', 'CreateVersion'), ['create','document_id' => $request], ['class' => 'btn btn-primary']) ?>
        <?= Html::a(M::t('app', 'APIDetails'), ['/api/api/view?api_code=PublicationVersion'], ['class' => 'btn btn-primary', 'target' => '_blank']) ?>
    </p>
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>
    <div class="ibox animated fadeInRight">
        <div class="mail-box b-r-md">
            <?=
            GridView::widget([
                'dataProvider' => $dataProvider,
                'filterModel' => $searchModel,
                'tableOptions' => ['class' => 'table',],
                'summary' => '',
                'columns' => [
                    ['class' => 'yii\grid\SerialColumn'],
                    [
                        'attribute' => 'version_title',
                        'headerOptions' => ['style' => 'width:30%'],
                    ],
                    [
                        'attribute' => 'version_no',
                        'headerOptions' => ['style' => 'width:10%'],
                    ],
                    [
                        'attribute' => 'version_language',
                        'headerOptions' => ['style' => 'width:10%'],
                        'filter' => ArrayHelper::map(
                                (new \yii\db\Query())->select(['code', $desc])
                                        ->from('ref')
                                        ->where(['=', 'cat', 'DOCUMENTLANGUAGE'])
                                        ->orderBy(['sort' => SORT_ASC])
                                        ->all(), 'code',$desc),
                        'value' => function ($model) {
                            $desc = 'descr';
                            if(Yii::$app->language == 'en'){
                                $desc = 'descr_en';
                            }
                            $ref = (new \yii\db\Query())->select([$desc])
                                    ->from('ref')
                                    ->where(['=', 'cat', 'DOCUMENTLANGUAGE'])
                                    ->andwhere(['=', 'code', $model->version_language])
                                    ->one();
                            if (!empty($ref))
                                return $ref[$desc];
                        }
                    ],
                    [
                        'attribute' => 'version_status',
                        'headerOptions' => ['style' => 'width:10%'],
                        'filter' => ArrayHelper::map(
                                (new \yii\db\Query())->select(['code', $desc])
                                        ->from('ref')
                                        ->where(['=', 'cat', 'DOCUMENTSTATUS'])
                                        ->orderBy(['sort' => SORT_ASC])
                                        ->all(), 'code', $desc),
                        'value' => function ($model) {
                            $desc = 'descr';
                            if(Yii::$app->language == 'en'){
                                $desc = 'descr_en';
                            }
                            $ref = (new \yii\db\Query())->select([$desc])
                                    ->from('ref')
                                    ->where(['=', 'cat', 'DOCUMENTSTATUS'])
                                    ->andwhere(['=', 'code', $model->version_status])
                                    ->one();
                            if (!empty($ref))
                                return $ref[$desc];
                        }
                    ],                    
                    [
                        'attribute' => 'approval_status',
                        'headerOptions' => ['style' => 'width:10%'],
                        'filter' => ArrayHelper::map(
                                (new \yii\db\Query())->select(['code', $desc])
                                        ->from('ref')
                                        ->where(['=', 'cat', 'APPROVALSTATUS'])
                                        ->orderBy(['sort' => SORT_ASC])
                                        ->all(), 'code', $desc),
                        'value' => function ($model) {
                            $desc = 'descr';
                            if(Yii::$app->language == 'en'){
                                $desc = 'descr_en';
                            }
                            $ref = (new \yii\db\Query())->select([$desc])
                                    ->from('ref')
                                    ->where(['=', 'cat', 'APPROVALSTATUS'])
                                    ->andwhere(['=', 'code', $model->approval_status])
                                    ->one();
                            if (!empty($ref))
                                return $ref[$desc];
                        }
                    ],
                    [
                        'attribute' => M::t('app','FileVersion'),
                        'headerOptions' => ['style' => 'width:10%'],
                        'value' => function ($model) {
                            $pdf = '';
                            $zip = '';
                            if(!empty($model->version_pdf))
                                $pdf =  '<a href="'.Yii::getAlias('@web') .'/'.$model->version_pdf. '" target="_blank"><i class="fa fa-file-pdf-o" aria-hidden="true"></i></a><br>';
                            if(!empty($model->version_zip))
                                $zip =  '<a href="'.Yii::getAlias('@web') .'/'.$model->version_zip. '" target="_blank"><i class="fa fa-file-archive-o" aria-hidden="true"></i></a> ';

                            return $pdf.'&nbsp;&nbsp;'.$zip;
                        
                        },
                        'format' => 'raw',
                    ],
                    [
                        'class' => 'yii\grid\ActionColumn',
                        'header' => M::t('app','Action'),
                        'template' => '{update} {delete}',
                        'headerOptions' => ['style' => 'text-align:center;width:10%'],
                        'contentOptions' => ['style' => 'text-align:center;'],
                        'buttons' => 
                                [
                                    'update' => function ($url, $model) {
                                        return Html::a('<span class="glyphicon glyphicon-pencil">',
                                        ['update', 'document_id' => $model->document_id, 'id' => $model->version_id],
                                        ['title' => 'Update','data-pjax' => '0']);
                                    },
                                ],

                    ],
                ],
            ]);
            ?>
        </div>
    </div>
</div>
