<?php

use yii\helpers\Html;
use yii\grid\GridView;
use yii\helpers\ArrayHelper;
use backend\modules\publicationDocument\Module as M;

/* @var $this yii\web\View */
/* @var $searchModel backend\modules\publicationDocument\models\PublicationVersionSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = M::t('app', 'Version');
$this->params['breadcrumbs'][] = $this->title;

    switch(Yii::$app->language){
        case 'en':
            $desc = 'descr_en';
            break;
        default:
            $desc = 'descr';
            break;
    }
?>
<div class="wrapper wrapper-publication">

    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>
    <div class="ibox animated fadeInRight">
        <div class="mail-box b-r-md">
            <?=
            GridView::widget([
                'dataProvider' => $dataProvider,
                'filterModel' => $searchModel,
                'tableOptions' => ['class' => 'table',],
                'summary' => '',
                'columns' => [
                    ['class' => 'yii\grid\SerialColumn'],
                    [
                        'attribute' => 'version_title',
                        'headerOptions' => ['style' => 'width:30%'],
                    ],
                    [
                        'attribute' => 'version_no',
                        'headerOptions' => ['style' => 'width:10%'],
                    ],
                    [
                        'attribute' => 'version_language',
                        'headerOptions' => ['style' => 'width:10%'],
                        'filter' => ArrayHelper::map(
                                (new \yii\db\Query())->select(['code', $desc])
                                        ->from('ref')
                                        ->where(['=', 'cat', 'DOCUMENTLANGUAGE'])
                                        ->orderBy(['sort' => SORT_ASC])
                                        ->all(), 'code',$desc),
                        'value' => function ($model) {
                            $desc = 'descr';
                            if(Yii::$app->language == 'en'){
                                $desc = 'descr_en';
                            }
                            $ref = (new \yii\db\Query())->select([$desc])
                                    ->from('ref')
                                    ->where(['=', 'cat', 'DOCUMENTLANGUAGE'])
                                    ->andwhere(['=', 'code', $model->version_language])
                                    ->one();
                            if (!empty($ref))
                                return $ref[$desc];
                        }
                    ],
                    [
                        'attribute' => 'approval_status',
                        'headerOptions' => ['style' => 'width:10%'],
                        'filter' => ArrayHelper::map(
                                (new \yii\db\Query())->select(['code', $desc])
                                        ->from('ref')
                                        ->where(['=', 'cat', 'APPROVALSTATUS'])
                                        ->where(['code' =>['appStatus01', 'appStatus03']])
                                        ->orderBy(['sort' => SORT_ASC])
                                        ->all(), 'code', $desc),
                        'value' => function ($model) {
                            $desc = 'descr';
                            if(Yii::$app->language == 'en'){
                                $desc = 'descr_en';
                            }
                            $ref = (new \yii\db\Query())->select([$desc])
                                    ->from('ref')
                                    ->where(['=', 'cat', 'APPROVALSTATUS'])
                                    ->andwhere(['=', 'code', $model->approval_status])
                                    ->one();
                            if (!empty($ref))
                                return $ref[$desc];
                        }
                    ],
                    [
                        'class' => 'yii\grid\ActionColumn',
                        'header' => 'Action',
                        'template' => '{view}',
                        'headerOptions' => ['style' => 'text-align:center;width:10%'],
                        'contentOptions' => ['style' => 'text-align:center;'],
                    ],
                ],
            ]);
            ?>
        </div>
    </div>
</div>
