<?php

use mihaildev\ckeditor\CKEditor;
use mihaildev\elfinder\ElFinder;
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use kartik\file\FileInput;
use backend\modules\publicationDocument\Module as M;

/* @var $this yii\web\View */
/* @var $model backend\modules\publicationDocument\models\PublicationVersion */
/* @var $form yii\widgets\ActiveForm */
$this->registerCssFile('@web/plugins/summernote/summernote.min.css');
$this->registerJsFile('@web/plugins/summernote/summernote.min.js', ['depends' => [\yii\web\JqueryAsset::className()]]);

$this->registerJs(
        <<<JS
    $('#publicationversion-version_date_start').datepicker({'format':'yyyy-mm-dd'});
    $('#publicationversion-version_date_end').datepicker({'format':'yyyy-mm-dd'});
    $('.summernote').summernote({height: 300});
JS
);
$this->registerCss(".note-editor{border:1px solid #e5e6e7 !important}
    .bootstrap-tagsinput input, .bootstrap-tagsinput {width:100% !important;}");

    switch(Yii::$app->language){
        case 'en':
            $desc = 'descr_en';
            break;
        default:
            $desc = 'descr';
            break;
    }

    $request = Yii::$app->request->get('document_id');

?>
<?php $form = ActiveForm::begin(); ?>
<div class="wrapper wrapper-content animated fadeInRight" style="padding: 20px 10px 20px;">
    <div class="ibox float-e-margins">
        <div class="ibox-content">
            <div class="row">
                <?= $form->field($model, 'document_id')->hiddenInput(['value'=> $request])->label(false); ?>
                <div class="col-sm-4"><?= $form->field($model, 'version_no')->textInput(['type' => 'number']) ?></div>

                <div class="col-sm-4">
                    <?=
                    $form->field($model, 'version_main')->dropdownList(
                            ArrayHelper::map(
                                    (new \yii\db\Query())->select(['code', $desc])
                                            ->from('ref')
                                            ->where(['=', 'cat', 'VERSIONMAIN'])
                                            ->orderBy(['sort' => SORT_ASC])
                                            ->all(), 'code', $desc), [
                        'maxlength' => true,])
                    ?>
                </div>

                <div class="col-sm-4">
                    <?=
                    $form->field($model, 'version_status')->dropdownList(
                            ArrayHelper::map(
                                    (new \yii\db\Query())->select(['code', $desc])
                                            ->from('ref')
                                            ->where(['=', 'cat', 'VERSIONSTATUS'])
                                            ->orderBy(['sort' => SORT_ASC])
                                            ->all(), 'code', $desc), [
                        'maxlength' => true,])
                    ?>
                </div>

                <div class="col-sm-6"><?= $form->field($model, 'version_date_start')->textInput() ?></div>

                <div class="col-sm-6"><?= $form->field($model, 'version_date_end')->textInput() ?></div>

                <div class="col-sm-4">
                    <?=
                    $form->field($model, 'version_language')->dropdownList(
                            ArrayHelper::map(
                                    (new \yii\db\Query())->select(['code', $desc ])
                                            ->from('ref')
                                            ->where(['=', 'cat', 'DOCUMENTLANGUAGE'])
                                            ->orderBy(['sort' => SORT_ASC])
                                            ->all(), 'code',$desc ), [
                        'maxlength' => true,])
                    ?>
                </div>

                <div class="col-sm-8"><?= $form->field($model, 'version_title')->textInput() ?></div>
            </div>

            <?= $form->field($model, 'version_content')->textarea(['class' => 'summernote']) ?>

            <?php
                $img_url = Yii::getAlias('@web') . '/images/noimage.jpg';
                if (!empty($model->version_img)) {
                    echo $form->field($model, 'version_img')->widget(FileInput::classname(), [
                        'options' => ['accept' => 'image/*'],
                        'pluginOptions' => [
                            'showUpload' => false,
                            'initialPreview' => [
                                '<img style="width:100%" src="' . Yii::getAlias('@web') . '/' . $model->version_img . '"/>',
                            ],
                        ]
                    ]);
                } else {
                    echo $form->field($model, 'version_img')->widget(FileInput::classname(), [
                        'options' => ['accept' => 'image/*'],
                    ]);
                }
            ?>
            </div>
        </div>
    <div class="ibox float-e-margins">
        <div class="ibox-content">
            <h3 style="text-align: center;"> Files</h3>
            <table class="table table-bordered" id="wrapper-version">
                <thead><tr><th>PDF File</th><th>Zip File</th></tr></thead>
                <tbody>
                    <?php
                        $pdf_view = '';
                        $zip_view = '';
                        if (!empty($model->version_pdf))
                            $pdf_view = '<a href="'.Yii::getAlias('@web') . '/' .$model->version_pdf . '" target="_blank" class="btn btn-danger btn-sm" style="margin-top:1em;">Lihat PDF</a>';
                        if(!empty($model->version_zip))
                            $zip_view = '<a href="'.Yii::getAlias('@web') . '/' .$model->version_zip . '" target="_blank" class="btn btn-danger btn-sm" style="margin-top:1em;">File ZIP</a>';
                        echo'
                        <tr>
                            <td>' . $form->field($model, 'version_pdf')->fileInput()->label(false)  . $pdf_view. '</td>
                            <td>' . $form->field($model, 'version_zip')->fileInput()->label(false) . $zip_view  . '</td>
                        </tr>';
                    ?>
                </tbody>
            </table>
        </div>
    </div>

    <div class="form-group">
        <?= Html::submitButton($model->isNewRecord ? M::t('app','Create') : M::t('app','Update'), ['class' => $model->isNewRecord ? 'btn btn-success' : 'btn btn-primary']) ?>
    </div>
</div>
<?php ActiveForm::end(); ?>