<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use backend\modules\publicationDocument\Module as M;

/* @var $this yii\web\View */
/* @var $model backend\modules\publicationDocument\models\PublicationDocument */

$this->title = $model->document_id;
$this->params['breadcrumbs'][] = ['label' => M::t('app', 'Publication Documents'), 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
?>
<div class="publication-document-view">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a(M::t('app', 'Update'), ['update', 'id' => $model->document_id], ['class' => 'btn btn-primary']) ?>
        <?= Html::a(M::t('app', 'Delete'), ['delete', 'id' => $model->document_id], [
            'class' => 'btn btn-danger',
            'data' => [
                'confirm' => M::t('app', 'Are you sure you want to delete this item?'),
                'method' => 'post',
            ],
        ]) ?>
    </p>

    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
            'document_id',
            'document_date',
            'document_category',
            'document_status',
            'document_url:url',
            'document_sorting',
            'document_image',
            'document_portal_category',
            'created_at',
            'created_by',
            'updated_at',
            'updated_by',
        ],
    ]) ?>

</div>
