<?php

use yii\helpers\Html;
use yii\grid\GridView;
use yii\helpers\ArrayHelper;
use backend\modules\publicationDocument\Module as M;
use backend\modules\publicationDocument\models\PublicationDocumentTranslation;

/* @var $this yii\web\View */
/* @var $searchModel backend\modules\publicationDocument\models\PublicationDocumentSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = M::t('app', 'Document');
$this->params['breadcrumbs'][] = $this->title;

    switch(Yii::$app->language){
        case 'en':
            $desc = 'descr_en';
            break;
        default:
            $desc = 'descr';
            break;
    }
?>
<div class="wrapper wrapper-publication">
    <p>
        <?= Html::a(M::t('app', 'CreateDocument'), ['create'], ['class' => 'btn btn-primary']) ?>
        <?= Html::a(M::t('app', 'APIList'), ['/api/api/view?api_code=PublicationDocumentList'], ['class' => 'btn btn-primary', 'target' => '_blank']) ?>
        <?= Html::a(M::t('app', 'APIDetails'), ['/api/api/view?api_code=PublicationDocumentDetails'], ['class' => 'btn btn-primary', 'target' => '_blank']) ?>
    </p>
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>
    <div class="ibox animated fadeInRight">
        <div class="mail-box b-r-md">
            <?=
            GridView::widget([
                'dataProvider' => $dataProvider,
                'filterModel' => $searchModel,
                'tableOptions' => ['class' => 'table',],
                'summary' => '',
                'columns' => [
                    ['class' => 'yii\grid\SerialColumn'],
                    [
                        'attribute' => 'document_title',
                        'value' => function ($model) {
                            if (($modeltranslation = PublicationDocumentTranslation::findOne(['document_translation_parent_id' => $model->document_id, 'document_translation_main' => 1])) !== null) {
                                return $modeltranslation->document_translation_title;
                            }
                        }
                    ],
                    [
                        'attribute' => 'document_category',
                        'headerOptions' => ['style' => 'width:10%'],
                        'filter' => ArrayHelper::map(
                                (new \yii\db\Query())->select(['code', $desc])
                                        ->from('ref')
                                        ->where(['=', 'cat', 'DOCUMENTCATEGORY'])
                                        ->orderBy(['sort' => SORT_ASC])
                                        ->all(), 'code', $desc),
                        'value' => function ($model) {
                             $desc = 'descr';
                            if(Yii::$app->language == 'en'){
                                $desc = 'descr_en';
                            }
                            $ref = (new \yii\db\Query())->select([$desc])
                                    ->from('ref')
                                    ->where(['=', 'cat', 'DOCUMENTCATEGORY'])
                                    ->andwhere(['=', 'code', $model->document_category])
                                    ->one();
                            if (!empty($ref))
                                return $ref[$desc];
                        }
                    ],
                    [
                        'attribute' => 'document_subcategory',
                        'headerOptions' => ['style' => 'width:10%'],
                        'filter' => ArrayHelper::map(
                                (new \yii\db\Query())->select(['code', $desc])
                                        ->from('ref')
                                        ->where(['=', 'cat', 'DOCUMENTSUBCATEGORY'])
                                        ->orderBy(['sort' => SORT_ASC])
                                        ->all(), 'code', $desc),
                        'value' => function ($model) {
                             $desc = 'descr';
                            if(Yii::$app->language == 'en'){
                                $desc = 'descr_en';
                            }
                            $ref = (new \yii\db\Query())->select([$desc])
                                    ->from('ref')
                                    ->where(['=', 'cat', 'DOCUMENTSUBCATEGORY'])
                                    ->andwhere(['=', 'code', $model->document_subcategory])
                                    ->one();
                            if (!empty($ref))
                                return $ref[$desc];
                        }
                    ], 
                    [
                        'attribute' => 'document_status',
                        'headerOptions' => ['style' => 'width:10%'],
                        'filter' => ArrayHelper::map(
                                (new \yii\db\Query())->select(['code', $desc])
                                        ->from('ref')
                                        ->where(['=', 'cat', 'DOCUMENTSTATUS'])
                                        ->orderBy(['sort' => SORT_ASC])
                                        ->all(), 'code', $desc),
                        'value' => function ($model) {
                             $desc = 'descr';
                            if(Yii::$app->language == 'en'){
                                $desc = 'descr_en';
                            }
                            $ref = (new \yii\db\Query())->select([$desc])
                                    ->from('ref')
                                    ->where(['=', 'cat', 'DOCUMENTSTATUS'])
                                    ->andwhere(['=', 'code', $model->document_status])
                                    ->one();
                            if (!empty($ref))
                                return $ref[$desc];
                        }
                    ],
                    [
                        'attribute' => 'document_date',
                        'headerOptions' => ['style' => 'width:10%'],
                    ], [
                        'header' => M::t('app','Language'),
                        'format' => 'raw',
                        'headerOptions' => ['style' => 'width:10%'],
                        'value' => function ($model) {
                            $output = '';
                            $arr = ArrayHelper::map(
                                            (new \yii\db\Query())->select(['*'])
                                                    ->from('publication_document_translation')
                                                    ->orderBy(['document_translation_language' => SORT_ASC])
                                                    ->groupby(['document_translation_language'])
                                                    ->all(), 'document_translation_language', 'document_translation_language');
                            $desc = 'descr';
                            if(Yii::$app->language == 'en'){
                                $desc = 'descr_en';
                            }
                            if (!empty($arr)) {
                                foreach ($arr as $code) {
                                    $ref = (new \yii\db\Query())->select([$desc])
                                            ->from('ref')
                                            ->where(['=', 'cat', 'DOCUMENTLANGUAGE'])
                                            ->andwhere(['=', 'code', $code])
                                            ->one();
                                    if (!empty($ref)) {
                                        $label_class = 'label-dark';
                                        if (($modeltranslation = PublicationDocumentTranslation::findOne(['document_translation_parent_id' => $model->document_id, 'document_translation_language' => $code])) !== null) {
                                            $label_class = 'label-primary';
                                        }
                                        $output .= '<span class="label ' . $label_class . '">' . $ref[$desc] . '</span>&nbsp;&nbsp;';
                                    }
                                }
                            }
                            return $output;
                        }
                    ],
                    [
                        'class' => 'yii\grid\ActionColumn',
                        'header' => M::t('app','Action'),
                        'template' => '{version} {update} {delete}',
                        'headerOptions' => ['style' => 'text-align:center;width:10%'],
                        'contentOptions' => ['style' => 'text-align:center;'],
                        'buttons' => [
                                    'version' => function ($url, $model) {
                                        return Html::a('<span class="fa fa-plus-circle">',
                                        ['publication-version/index', 'document_id' => $model->document_id],
                                        ['title' => 'Add Version','data-pjax' => '0']);
                                    },
                                ],
                    ],
                ],
            ]);
            ?>
        </div>
    </div>
</div>
