<?php

use mihaildev\ckeditor\CKEditor;
use mihaildev\elfinder\ElFinder;
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use kartik\file\FileInput;
use backend\modules\publicationDocument\models\PublicationDocumentTranslation;
use backend\modules\publicationDocument\Module as M;

/* @var $this yii\web\View */
/* @var $model backend\modules\publicationDocument\models\PublicationDocument */
/* @var $form yii\widgets\ActiveForm */
$this->registerCssFile('@web/plugins/summernote/summernote.min.css');
$this->registerJsFile('@web/plugins/summernote/summernote.min.js', ['depends' => [\yii\web\JqueryAsset::className()]]);

$this->registerJs(
        <<<JS
    $('#publicationdocument-document_date').datepicker({'format':'yyyy-mm-dd'});
    $('.summernote').summernote({height: 300});
JS
);
$this->registerCss(".note-editor{border:1px solid #e5e6e7 !important}
    .bootstrap-tagsinput input, .bootstrap-tagsinput {width:100% !important;}");

    switch(Yii::$app->language){
        case 'en':
            $desc = 'descr_en';
            break;
        default:
            $desc = 'descr';
            break;
    }
?>
<?php $form = ActiveForm::begin(); ?>
<div class="wrapper wrapper-content animated fadeInRight" style="padding: 20px 10px 20px;">
    <div class="ibox float-e-margins">
        <div class="ibox-content">
            <div class="row">
                <div class="col-sm-4">
                    <?=
                    $form->field($model, 'document_category')->dropdownList(
                            ArrayHelper::map(
                                    (new \yii\db\Query())->select(['code', $desc])
                                            ->from('ref')
                                            ->where(['=', 'cat', 'DOCUMENTCATEGORY'])
                                            ->orderBy(['sort' => SORT_ASC])
                                            ->all(), 'code', $desc), [
                        'maxlength' => true, 'onchange' => 'changecategory(this.value)', 'prompt' => '-- Please choose --'])
                    ?>
                </div>
                <div class="col-sm-4">
                    <?=
                    $form->field($model, 'document_subcategory')->dropdownList(
                            ArrayHelper::map(
                                    (new \yii\db\Query())->select(['code', $desc])
                                            ->from('ref')
                                            ->where(['=', 'cat', 'DOCUMENTSUBCATEGORY'])
                                            ->andwhere(['=', 'param1', $model->document_category])
                                            ->orderBy(['sort' => SORT_ASC])
                                            ->all(), 'code', $desc), [
                        'maxlength' => true, 'prompt' => '-- Please choose --'])
                    ?>
                </div>
                <div class="col-sm-4">
                    <?=
                    $form->field($model, 'document_status')->dropdownList(
                            ArrayHelper::map(
                                    (new \yii\db\Query())->select(['code', $desc])
                                            ->from('ref')
                                            ->where(['=', 'cat', 'DOCUMENTSTATUS'])
                                            ->orderBy(['sort' => SORT_ASC])
                                            ->all(), 'code', $desc), [
                        'maxlength' => true,])
                    ?>
                </div>
                <div class="col-sm-6"><?= $form->field($model, 'document_date')->textInput() ?></div>

                <div class="col-sm-6"><?= $form->field($model, 'document_sorting')->textInput() ?></div>
                <div class="col-sm-6">
                    <?php
                        $img_url = Yii::getAlias('@web') . '/images/noimage.jpg';
                        if (!empty($model->document_image)) {
                            echo $form->field($model, 'document_image')->widget(FileInput::classname(), [
                                'options' => ['accept' => 'image/*'],
                                'pluginOptions' => [
                                    'showUpload' => false,
                                    'initialPreview' => [
                                        '<img style="width:100%" src="' . Yii::getAlias('@web') . '/' . $model->document_image . '"/>',
                                    ],
                                ]
                            ]);
                        } else {
                            echo $form->field($model, 'document_image')->widget(FileInput::classname(), [
                                'options' => ['accept' => 'image/*'],
                            ]);
                        }
                        ?>
                </div>
                <div class="col-sm-6">
                    <?php
                        $img_url = Yii::getAlias('@web') . '/images/noimage.jpg';
                        if (!empty($model->document_bckgd)) {
                            echo $form->field($model, 'document_bckgd')->widget(FileInput::classname(), [
                                'options' => ['accept' => 'image/*'],
                                'pluginOptions' => [
                                    'showUpload' => false,
                                    'initialPreview' => [
                                        '<img style="width:100%" src="' . Yii::getAlias('@web') . '/' . $model->document_bckgd . '"/>',
                                    ],
                                ]
                            ]);
                        } else {
                            echo $form->field($model, 'document_bckgd')->widget(FileInput::classname(), [
                                'options' => ['accept' => 'image/*'],
                            ]);
                        }
                        ?>
                </div>
            </div>
            
        </div>
    </div>

    <div class="ibox float-e-margins">
        <div class="ibox-content">
            <div class="row">
                <div class="col-sm-4">
                    <?=
                    $form->field($model, 'document_language')->dropdownList(
                            ArrayHelper::map(
                                    (new \yii\db\Query())->select(['code', $desc])
                                            ->from('ref')
                                            ->where(['=', 'cat', 'DOCUMENTLANGUAGE'])
                                            ->orderBy(['sort' => SORT_ASC])
                                            ->all(), 'code', $desc), [
                        'maxlength' => true,])
                    ?>
                </div>
                <div class="col-sm-8"><?= $form->field($model, 'document_title')->textInput() ?></div>
            </div>


            <?= $form->field($model, 'document_content')->textarea(['class' => 'summernote']) ?>
        </div> 
    </div>
    <?php
    $modeltranslation = PublicationDocumentTranslation::find()
                    ->where(['=', 'document_translation_parent_id', $model->document_id])
                    ->andwhere(['=', 'document_translation_main', '0'])
                    ->orderBy(['document_translation_id' => SORT_ASC])->all();
    if (!empty($modeltranslation)) {
        foreach ($modeltranslation as $rowtranslation) {
            echo '<div class="ibox float-e-margins" id="old-translation-' . $rowtranslation->document_translation_id . '">
            <input type="hidden" name="oldtranslation[]" value="' . $rowtranslation->document_translation_id . '">
            <div class="ibox-title">
                <button type="button" class="btn btn-primary btn-sm" onclick="deleteoldtranslation(' . $rowtranslation->document_translation_id . ')">'.M::t('app','Delete').'</button>&nbsp;&nbsp;&nbsp;
                '.M::t('app','DocumentTranslation').'
            </div>
            <div class="ibox-content">
                <div class="row">
                    <div class="col-sm-4">
                        <div class="form-group">
                            <label>'.M::t('app','Language').'</label>
                            ' . Html::dropDownList('old_language_' . $rowtranslation->document_translation_id, $rowtranslation->document_translation_language, ArrayHelper::map(
                            (new \yii\db\Query())->select(['code', $desc])
                                    ->from('ref')
                                    ->where(['=', 'cat', 'DOCUMENTLANGUAGE'])
                                    ->orderBy(['sort' => SORT_ASC])
                                    ->all(), 'code', $desc), [
                'class' => 'form-control',]) . '
                        </div>
                    </div>
                    <div class="col-sm-8">
                        <div class="form-group">
                            <label>'.M::t('app','Title').'</label>
                            <input type="text" class="form-control" name="old_title_' . $rowtranslation->document_translation_id . '" value="' . $rowtranslation->document_translation_title . '">
                        </div>
                    </div>
                </div>
                <div class="form-group">
                    <label>'.M::t('app','Content').'</label>
                    <textarea class="summernote" name="old_publication_' . $rowtranslation->document_translation_id . '">' . $rowtranslation->document_translation_content . '</textarea>
                </div>
            </div>
        </div>';
        }
    }
    ?>
    <div id="wrapper-translation"></div>

    <div class="form-group">
        <?= Html::submitButton($model->isNewRecord ? M::t('app','Create') : M::t('app','Update'), ['class' => $model->isNewRecord ? 'btn btn-success' : 'btn btn-primary']) ?>
        <?php
        if (!$model->isNewRecord){
            echo Html::button(M::t('app','AddTranslation'), ['class' => 'btn btn-primary', 'onclick' => 'addtranslation()']);
            echo '&nbsp;&nbsp;';
            echo Html::a(M::t('app','AddVersion'), ['publication-version/index', 'document_id' => $model->document_id],['class' => 'btn btn-primary']);
        } ?>
    </div>
</div>
<?php ActiveForm::end(); ?>
<script>
    function changecategory(parent_code) {
        $.ajax({
            url: "getsubcategory?parent_code=" + parent_code,
            method: "GET",
            success: function (response) {
                $('#publicationdocument-document_subcategory').find('option').not(':first').remove();
                $('#publicationdocument-document_subcategory').append(response);
            },
        });
    }

    var newcount = 1;
    function addtranslation() {
        newcount++;
        $.ajax({
            url: "addtranslation?no=" + newcount,
            method: "GET",
            success: function (response) {
                $('#wrapper-translation').append(response);
                $('.summernote').summernote({height: 300});
            },
        });
    }

    function deletenewtranslation(no) {
        $('#new-translation-' + no).remove();
    }

    function deleteoldtranslation(id) {
        var r = confirm("Are you sure to delete this data?");
        if (r == true) {
            $.ajax({
                url: "deletetranslation?id=" + id,
                method: "GET",
                success: function (response) {
                    $('#old-translation-' + id).remove();
                },
            });
        }
    }
</script>