<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

/* @var $this yii\web\View */
/* @var $model backend\modules\publicationDocument\models\PublicationDocumentTranslation */

$this->title = $model->document_translation_id;
$this->params['breadcrumbs'][] = ['label' => M::t('app', 'Publication Document Translations'), 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
?>
<div class="publication-document-translation-view">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a(M::t('app', 'Update'), ['update', 'id' => $model->document_translation_id], ['class' => 'btn btn-primary']) ?>
        <?= Html::a(M::t('app', 'Delete'), ['delete', 'id' => $model->document_translation_id], [
            'class' => 'btn btn-danger',
            'data' => [
                'confirm' => M::t('app', 'Are you sure you want to delete this item?'),
                'method' => 'post',
            ],
        ]) ?>
    </p>

    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
            'document_translation_id',
            'document_translation_parent_id',
            'document_translation_title:ntext',
            'document_translation_content:ntext',
            'created_at',
            'created_by',
            'updated_at',
            'updated_by',
        ],
    ]) ?>

</div>
