<?php

use yii\helpers\Html;
use yii\grid\GridView;

/* @var $this yii\web\View */
/* @var $searchModel backend\modules\publicationDocument\models\PublicationDocumentTranslationSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = M::t('app', 'Publication Document Translations');
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="publication-document-translation-index">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a(M::t('app', 'Create Publication Document Translation'), ['create'], ['class' => 'btn btn-success']) ?>
    </p>

    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],

            'document_translation_id',
            'document_translation_parent_id',
            'document_translation_title:ntext',
            'document_translation_content:ntext',
            //'created_at',
            //'created_by',
            //'updated_at',
            //'updated_by',

            ['class' => 'yii\grid\ActionColumn'],
        ],
    ]); ?>


</div>
