<?php

namespace backend\modules\publicationDocument\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\modules\publicationDocument\models\PublicationVersion;

/**
 * PublicationVersionSearch represents the model behind the search form of `backend\modules\publicationDocument\models\PublicationVersion`.
 */
class PublicationVersionSearch extends PublicationVersion {

    /**
     * {@inheritdoc}
     */
    public function rules() {
        return [
            [[ 'document_id', 'created_by', 'updated_by','approval_by','version_no','version_main'], 'integer'],
            [[ 'created_at', 'updated_at', 'version_date_start', 'version_date_end', 'approval_at', 'version_title', 'version_content', 'version_img', 'version_status', 'approval_status','version_language', 'version_pdf', 'version_zip'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios() {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params) {
        $query = PublicationVersion::find()
                ->innerJoin('publication_document', 'publication_document.document_id=publication_version.document_id');

        // add conditions that should always apply here
        $dataProvider = new ActiveDataProvider(['query' => $query, 'pagination' => ['pageSize' => 10,]]);
        $dataProvider->setSort(['defaultOrder' => ['updated_at' => SORT_DESC]]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere(['=', 'publication_version.document_id', $this->document_id]);
        $query->andFilterWhere(['=', 'version_no', $this->version_no]);
        $query->andFilterWhere(['=', 'version_status', $this->version_status]);
        $query->andFilterWhere(['=', 'approval_status', $this->approval_status]);


        return $dataProvider;
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function searchcheck($params) {
        $query = PublicationVersion::find()
                ->innerJoin('publication_document', 'publication_document.document_id=publication_version.document_id');
                
        $query->where(['=', 'approval_status', 'appStatus01']);

        // add conditions that should always apply here
        $dataProvider = new ActiveDataProvider(['query' => $query, 'pagination' => ['pageSize' => 10,]]);
        $dataProvider->setSort(['defaultOrder' => ['updated_at' => SORT_DESC]]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere(['=', 'publication_version.document_id', $this->document_id]);
        $query->andFilterWhere(['=', 'version_no', $this->version_no]);
        $query->andFilterWhere(['=', 'version_status', $this->version_status]);

        return $dataProvider;
    }

}
