<?php

namespace backend\modules\publicationDocument\models;

use Yii;
use backend\modules\publicationDocument\Module as M;

/**
 * This is the model class for table "publication_version".
 *
 * @property int $version_id
 * @property int|null $document_id
 * @property int|null $version_no
 * @property int|null $version_main
 * @property string|null $version_title
 * @property string|null $version_content
 * @property string|null $version_language
 * @property string|null $version_img
 * @property string|null $version_date_start
 * @property string|null $version_date_end
 * @property string|null $version_status
 * @property string|null $version_pdf
 * @property string|null $version_zip
 * @property string|null $approval_status
 * @property int|null $approval_by
 * @property string|null $approval_at
 * @property string|null $created_at
 * @property int|null $created_by
 * @property string|null $updated_at
 * @property int|null $updated_by
 */
class PublicationVersion extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'publication_version';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [[ 'document_id', 'version_no'], 'required'],
            [[ 'document_id', 'created_by', 'updated_by','approval_by','version_no'], 'integer'],
            [[ 'created_at', 'updated_at', 'version_date_start', 'version_date_end', 'approval_at', 'version_title', 'version_content'], 'safe'],
            [[ 'version_img', 'version_status', 'approval_status','version_language', 'version_pdf', 'version_zip', 'version_main'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'version_id' => M::t('app', 'VersionID'),
            'document_id' => M::t('app', 'DocumentID'),
            'version_no' => M::t('app', 'Version'),
            'version_main' => M::t('app', 'VersionMain'),
            'version_title' => M::t('app', 'Title'),
            'version_content' => M::t('app', 'Content'),
            'version_language' => M::t('app', 'Language'),
            'version_img' => M::t('app', 'Thumbnail'),
            'version_date_start' => M::t('app', 'StartPublish'),
            'version_date_end' => M::t('app', 'EndPublish'),
            'version_status' => M::t('app', 'VersionStatus'),
            'version_pdf' => M::t('app', 'PDFFile'),
            'version_zip' => M::t('app', 'ZipFile'),
            'approval_status' => M::t('app', 'ApprovalStatus'),
            'approval_by' => M::t('app', 'ApprovalBy'),
            'approval_at' => M::t('app', 'ApprovalAt'),
            'created_at' => M::t('app', 'CreatedAt'),
            'created_by' => M::t('app', 'CreatedBy'),
            'updated_at' => M::t('app', 'UpdatedAt'),
            'updated_by' => M::t('app', 'UpdatedBy'),
        ];
    }
}
