<?php

namespace backend\modules\publicationDocument\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\modules\publicationDocument\models\PublicationDocumentTranslation;

/**
 * PublicationDocumentTranslationSearch represents the model behind the search form of `backend\modules\publicationDocument\models\PublicationDocumentTranslation`.
 */
class PublicationDocumentTranslationSearch extends PublicationDocumentTranslation
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['document_translation_id', 'document_translation_parent_id', 'created_by', 'updated_by'], 'integer'],
            [['document_translation_title', 'document_translation_content', 'created_at', 'updated_at'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = PublicationDocumentTranslation::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'document_translation_id' => $this->document_translation_id,
            'document_translation_parent_id' => $this->document_translation_parent_id,
            'created_at' => $this->created_at,
            'created_by' => $this->created_by,
            'updated_at' => $this->updated_at,
            'updated_by' => $this->updated_by,
        ]);

        $query->andFilterWhere(['like', 'document_translation_title', $this->document_translation_title])
            ->andFilterWhere(['like', 'document_translation_content', $this->document_translation_content]);

        return $dataProvider;
    }
}
