<?php

namespace backend\modules\publicationDocument\models;

use Yii;
use backend\modules\publicationDocument\Module as M;

/**
 * This is the model class for table "publication_document_translation".
 *
 * @property int $document_translation_id
 * @property int|null $document_translation_parent_id
 * @property string|null $document_translation_title
 * @property string|null $document_translation_content
 * @property string|null $created_at
 * @property int|null $created_by
 * @property string|null $updated_at
 * @property int|null $updated_by
 */
class PublicationDocumentTranslation extends \yii\db\ActiveRecord {

    /**
     * {@inheritdoc}
     */
    public static function tableName() {
        return 'publication_document_translation';
    }

    /**
     * {@inheritdoc}
     */
    public function rules() {
        return [
            [['document_translation_parent_id', 'created_by', 'updated_by', 'document_translation_main'], 'integer'],
            [['document_translation_title', 'document_translation_content'], 'string'],
            [['created_at', 'updated_at'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels() {
        return [
            'document_translation_id' => M::t('app', 'Document Translation ID'),
            'document_translation_parent_id' => M::t('app', 'Document Translation Parent ID'),
            'document_translation_title' => M::t('app', 'Document Translation Title'),
            'document_translation_content' => M::t('app', 'Document Translation Publication'),
            'created_at' => M::t('app', 'Created At'),
            'created_by' => M::t('app', 'Created By'),
            'updated_at' => M::t('app', 'Updated At'),
            'updated_by' => M::t('app', 'Updated By'),
        ];
    }

}
