<?php

namespace backend\modules\publicationDocument\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\modules\publicationDocument\models\PublicationDocument;

/**
 * PublicationDocumentSearch represents the model behind the search form of `backend\modules\publicationDocument\models\PublicationDocument`.
 */
class PublicationDocumentSearch extends PublicationDocument {

    public $document_title;

    /**
     * {@inheritdoc}
     */
    public function rules() {
        return [
            [['document_id', 'document_sorting', 'created_by', 'updated_by'], 'integer'],
            [['document_date', 'document_category', 'document_subcategory', 'document_status', 'document_image', 'created_at', 'updated_at', 'document_title', 'document_content'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios() {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params) {
        $query = PublicationDocument::find()
                ->innerJoin('publication_document_translation', 'publication_document_translation.document_translation_parent_id=publication_document.document_id')
                ->where(['=', 'publication_document_translation.document_translation_main', '1']);

        // add conditions that should always apply here
        $dataProvider = new ActiveDataProvider(['query' => $query, 'pagination' => ['pageSize' => 10,]]);
        $dataProvider->setSort(['defaultOrder' => ['updated_at' => SORT_DESC]]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere(['LIKE', 'document_date', $this->document_date]);
        $query->andFilterWhere(['=', 'document_category', $this->document_category]);
        $query->andFilterWhere(['=', 'document_subcategory', $this->document_subcategory]);
        $query->andFilterWhere(['=', 'document_status', $this->document_status]);
        $query->andFilterWhere(['LIKE', 'document_translation_title', $this->document_title]);
        $query->andFilterWhere(['LIKE', 'document_translation_content', $this->document_content]);


        return $dataProvider;
    }

}
