<?php

namespace backend\modules\publicationDocument\models;

use Yii;
use backend\modules\publicationDocument\Module as M;

/**
 * This is the model class for table "publication_document".
 *
 * @property int $document_id
 * @property string|null $document_date
 * @property string|null $document_category
 * @property string|null $document_subcategory
 * @property string|null $document_status
 * @property int|null $document_sorting
 * @property string|null $document_image
 * @property string|null $document_bckgd
 * @property string|null $created_at
 * @property int|null $created_by
 * @property string|null $updated_at
 * @property int|null $updated_by
 */
class PublicationDocument extends \yii\db\ActiveRecord {

    public $document_title;
    public $document_content;
    public $document_language;

    /**
     * {@inheritdoc}
     */
    public static function tableName() {
        return 'publication_document';
    }

    /**
     * {@inheritdoc}
     */
    public function rules() {
        return [
            [['document_title', 'document_content', 'document_language','document_category'], 'required'],
            [['document_date', 'created_at', 'updated_at'], 'safe'],
            [['document_sorting', 'created_by', 'updated_by'], 'integer'],
            [['document_category', 'document_subcategory', 'document_status', 'document_image', 'document_bckgd'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels() {
        return [
            'document_id' => M::t('app', 'DocumentID'),
            'document_date' => M::t('app', 'Date'),
            'document_category' => M::t('app', 'Category'),
            'document_subcategory' => M::t('app', 'Subcategory'),
            'document_status' => M::t('app', 'Status'),
            'document_sorting' => M::t('app', 'Sorting'),
            'document_image' => M::t('app', 'Thumbnail'),
            'document_bckgd' => M::t('app', 'Background'),
            'created_at' => M::t('app', 'CreatedAt'),
            'created_by' => M::t('app', 'CreatedBy'),
            'updated_at' => M::t('app', 'UpdatedAt'),
            'updated_by' => M::t('app', 'UpdatedBy'),
            'document_title' => M::t('app', 'Title'),
            'document_content' => M::t('app', 'Content'),
            'document_language' => M::t('app', 'Language'),
        ];
    }

}
