<?php

namespace backend\modules\publicationDocument\controllers;

use Yii;
use backend\modules\publicationDocument\models\PublicationVersion;
use backend\modules\publicationDocument\models\PublicationVersionSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\web\UploadedFile;
use yii\helpers\ArrayHelper;
use yii\helpers\Html;
use backend\modules\publicationDocument\Module as M;

/**
 * PublicationVersionController implements the CRUD actions for PublicationVersion model.
 */
class PublicationVersionController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all PublicationVersion models.
     * @return mixed
     */
    public function actionIndex($document_id = '')
    {
        $searchModel = new PublicationVersionSearch();
        $searchModel->document_id = $document_id;
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
            'document_id' => $document_id,
        ]);
    }

    /**
     * Lists all PublicationVersion models.
     * @return mixed
     */
    public function actionCheck()
    {
        $searchModel = new PublicationVersionSearch();
        $dataProvider = $searchModel->searchcheck(Yii::$app->request->queryParams);

        return $this->render('check', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single PublicationVersion model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new PublicationVersion model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate($document_id = '')
    {
        $model = new PublicationVersion();
        $model->created_at = date("Y-m-d H:i:s");
        $model->created_by = Yii::$app->user->identity->id;
        $model->updated_at = date("Y-m-d H:i:s");
        $model->updated_by = Yii::$app->user->identity->id;
        $model->approval_status = 'appStatus01';
        $model->document_id = $document_id;

        if ($model->load(Yii::$app->request->post())) {

            $model->version_img = UploadedFile::getInstance($model, 'version_img');
            if (!empty($model->version_img)) {
                $version_img = 'images/modules/publicationVersionImg_' . date("YmdHis") . '.' . $model->version_img->extension;
                if ($model->version_img->saveAs($version_img))
                    $model->version_img = $version_img;
            }

            $model->version_pdf = UploadedFile::getInstance($model, 'version_pdf');
            if (!empty($model->version_pdf)) {
                $version_pdf = 'files/modules/publicationVersionPDF_' . date("YmdHis") . '.' . $model->version_pdf->extension;
                if ($model->version_pdf->saveAs($version_pdf))
                    $model->version_pdf = $version_pdf;
            }

            $model->version_zip = UploadedFile::getInstance($model, 'version_zip');
            if (!empty($model->version_zip)) {
                $version_zip = 'zip_files/modules/publicationVersionZIP_' . date("YmdHis") . '.' . $model->version_zip->extension;
                if ($model->version_zip->saveAs($version_zip))
                    $model->version_zip = $version_zip;
            }

            if ($model->save()) {

                return $this->redirect(['index', 'document_id' => $document_id]);
            }
        }

        return $this->render('create', [
            'model' => $model,
            'document_id' => $document_id,
        ]);
    }

    /**
     * Updates an existing PublicationVersion model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id, $document_id = '')
    {
        $model = $this->findModel($id);        
        $model->updated_at = date("Y-m-d H:i:s");
        $model->updated_by = Yii::$app->user->identity->id;
        $original_thumbnail = $model->version_img;
        $original_pdf = $model->version_pdf;
        $original_zip = $model->version_zip;
        $model->document_id = $document_id;

        if ($model->load(Yii::$app->request->post())) {

            $model->version_img = UploadedFile::getInstance($model, 'version_img');
            if (!empty($model->version_img)) {
                $version_img = 'images/modules/publicationVersionImg_' . date("YmdHis") . '.' . $model->version_img->extension;
                if ($model->version_img->saveAs($version_img))
                    $model->version_img = $version_img;
            } else
                $model->version_img = $original_thumbnail;

            $model->version_pdf = UploadedFile::getInstance($model, 'version_pdf');
            if (!empty($model->version_pdf)) {
                $version_pdf = 'files/modules/publicationVersionPDF_' . date("YmdHis") . '.' . $model->version_pdf->extension;
                if ($model->version_pdf->saveAs($version_pdf))
                    $model->version_pdf = $version_pdf;
            } else
                $model->version_pdf = $original_pdf;

            $model->version_zip = UploadedFile::getInstance($model, 'version_zip');
            if (!empty($model->version_zip)) {
                $version_zip = 'zip_files/modules/publicationVersionZIP_' . date("YmdHis") . '.' . $model->version_zip->extension;
                if ($model->version_zip->saveAs($version_zip))
                    $model->version_zip = $version_zip;
            } else
                $model->version_zip = $original_zip;

            if ($model->save()) {
                return $this->redirect(['index', 'document_id' => $document_id]);
            }
            
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing PublicationVersion model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['publication-document/index']);
    }

    /**
     * Finds the PublicationVersion model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return PublicationVersion the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = PublicationVersion::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException(M::t('app', 'PageNotExist'));
    }

    public function actionApprove($id) {
        $model = $this->findModel($id);
        $model->approval_status = 'appStatus02';
        $model->approval_at = date("Y-m-d H:i:s");
        $model->approval_by = Yii::$app->user->identity->id;
        $model->updated_at = date("Y-m-d H:i:s");
        $model->updated_by = Yii::$app->user->identity->id;
        if ($model->save())
            return $this->redirect(['check']);
    }

    public function actionReject($id) {
        $model = $this->findModel($id);
        $model->approval_status = 'appStatus03';
        $model->approval_at = date("Y-m-d H:i:s");
        $model->approval_by = Yii::$app->user->identity->id;
        $model->updated_at = date("Y-m-d H:i:s");
        $model->updated_by = Yii::$app->user->identity->id;
        if ($model->save())
            return $this->redirect(['check']);
    }
}
