<?php

namespace backend\modules\publicationDocument\controllers;

use Yii;
use backend\modules\publicationDocument\models\PublicationDocument;
use backend\modules\publicationDocument\models\PublicationDocumentTranslation;
use backend\modules\publicationDocument\models\PublicationDocumentSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\web\UploadedFile;
use yii\helpers\ArrayHelper;
use yii\helpers\Html;
use backend\modules\publicationDocument\Module as M;

/**
 * PublicationDocumentController implements the CRUD actions for PublicationDocument model.
 */
class PublicationDocumentController extends Controller {

    /**
     * {@inheritdoc}
     */
    public function behaviors() {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all PublicationDocument models.
     * @return mixed
     */
    public function actionIndex() {
        $searchModel = new PublicationDocumentSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
                    'searchModel' => $searchModel,
                    'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single PublicationDocument model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id) {
        return $this->render('view', [
                    'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new PublicationDocument model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate() {
        $model = new PublicationDocument();
        $model->created_at = date("Y-m-d H:i:s");
        $model->created_by = Yii::$app->user->identity->id;
        $model->updated_at = date("Y-m-d H:i:s");
        $model->updated_by = Yii::$app->user->identity->id;
        $model->document_language = 'Malay';
        if ($model->load(Yii::$app->request->post())) {
            $model->document_image = UploadedFile::getInstance($model, 'document_image');
            if (!empty($model->document_image)) {
                $document_image = 'images/modules/publicationDocumentImg_' . date("YmdHis") . '.' . $model->document_image->extension;
                if ($model->document_image->saveAs($document_image))
                    $model->document_image = $document_image;
            }

            $model->document_bckgd = UploadedFile::getInstance($model, 'document_bckgd');
            if (!empty($model->document_bckgd)) {
                $document_bckgd = 'images/modules/publicationDocumentBckgd_' . date("YmdHis") . '.' . $model->document_bckgd->extension;
                if ($model->document_bckgd->saveAs($document_bckgd))
                    $model->document_bckgd = $document_bckgd;
            }

            if ($model->save()) {

                $modeltranslation = new PublicationDocumentTranslation();
                $modeltranslation->document_translation_parent_id = $model->document_id;
                $modeltranslation->document_translation_title = $model->document_title;
                $modeltranslation->document_translation_content = $model->document_content;
                $modeltranslation->document_translation_language = $model->document_language;
                $modeltranslation->document_translation_main = 1;
                $modeltranslation->created_at = date("Y-m-d H:i:s");
                $modeltranslation->created_by = Yii::$app->user->identity->id;
                $modeltranslation->updated_at = date("Y-m-d H:i:s");
                $modeltranslation->updated_by = Yii::$app->user->identity->id;
                $modeltranslation->save();

                return $this->redirect(['index']);
            }
        }
        return $this->render('create', [
                    'model' => $model,
        ]);
    }

    /**
     * Updates an existing PublicationDocument model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id) {
        $model = $this->findModel($id);
        $model->updated_at = date("Y-m-d H:i:s");
        $model->updated_by = Yii::$app->user->identity->id;
        $original_thumbnail = $model->document_image;
        $original_background = $model->document_bckgd;

        $translation_id = '';

        if (($modeltranslation = PublicationDocumentTranslation::findOne(['document_translation_parent_id' => $model->document_id, 'document_translation_main' => 1])) !== null) {
            $translation_id = $modeltranslation->document_translation_id;
            $model->document_title = $modeltranslation->document_translation_title;
            $model->document_content = $modeltranslation->document_translation_content;
            $model->document_language = $modeltranslation->document_translation_language;
        }

        if ($model->load(Yii::$app->request->post())) {
            $model->document_image = UploadedFile::getInstance($model, 'document_image');
            if (!empty($model->document_image)) {
                $document_image = 'images/modules/publicationDocument_' . date("YmdHis") . '.' . $model->document_image->extension;
                if ($model->document_image->saveAs($document_image))
                    $model->document_image = $document_image;
            } else
                $model->document_image = $original_thumbnail;

            $model->document_bckgd = UploadedFile::getInstance($model, 'document_bckgd');
            if (!empty($model->document_bckgd)) {
                $document_bckgd = 'images/modules/publicationDocumentBckgd_' . date("YmdHis") . '.' . $model->document_bckgd->extension;
                if ($model->document_bckgd->saveAs($document_bckgd))
                    $model->document_bckgd = $document_bckgd;
            }else
                $model->document_bckgd = $original_background;

            if ($model->save()) {
                if (($modeltranslation = PublicationDocumentTranslation::findOne($translation_id)) !== null) {
                    $modeltranslation->document_translation_title = $model->document_title;
                    $modeltranslation->document_translation_content = $model->document_content;
                    $modeltranslation->document_translation_language = $model->document_language;
                    $modeltranslation->updated_at = date("Y-m-d H:i:s");
                    $modeltranslation->updated_by = Yii::$app->user->identity->id;
                    $modeltranslation->save();
                }

                //insert new translation
                if (isset($_POST['newtranslation']) && !empty($_POST['newtranslation'])) {
                    foreach ($_POST['newtranslation'] as $newno) {
                        $modeltranslationnew = new PublicationDocumentTranslation();
                        $modeltranslationnew->document_translation_parent_id = $model->document_id;
                        $modeltranslationnew->document_translation_title = $_POST['new_title_' . $newno];
                        $modeltranslationnew->document_translation_content = $_POST['new_publication_' . $newno];
                        $modeltranslationnew->document_translation_language = $_POST['new_language_' . $newno];
                        $modeltranslationnew->document_translation_main = 0;
                        $modeltranslationnew->created_at = date("Y-m-d H:i:s");
                        $modeltranslationnew->created_by = Yii::$app->user->identity->id;
                        $modeltranslationnew->updated_at = date("Y-m-d H:i:s");
                        $modeltranslationnew->updated_by = Yii::$app->user->identity->id;
                        $modeltranslationnew->save();
                    }
                }

                //update translation
                if (isset($_POST['oldtranslation']) && !empty($_POST['oldtranslation'])) {
                    foreach ($_POST['oldtranslation'] as $oldtranslation) {
                        if (($modeltranslationupdate = PublicationDocumentTranslation::findOne($oldtranslation)) !== null) {
                            $modeltranslationupdate->document_translation_title = $_POST['old_title_' . $oldtranslation];
                            $modeltranslationupdate->document_translation_content = $_POST['old_publication_' . $oldtranslation];
                            $modeltranslationupdate->document_translation_language = $_POST['old_language_' . $oldtranslation];
                            $modeltranslationupdate->updated_at = date("Y-m-d H:i:s");
                            $modeltranslationupdate->updated_by = Yii::$app->user->identity->id;
                            $modeltranslationupdate->save();
                        }
                    }
                }

                return $this->redirect(['index']);
            }
        }
        return $this->render('update', ['model' => $model,]);
    }

    /**
     * Deletes an existing PublicationDocument model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id) {
        PublicationDocumentTranslation::deleteAll(['document_translation_parent_id' => $id]);
        $this->findModel($id)->delete();
        return $this->redirect(['index']);
    }

    /**
     * Finds the PublicationDocument model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return PublicationDocument the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id) {
        if (($model = PublicationDocument::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException(M::t('app', 'PageNotExist'));
    }

    public function actionGetsubcategory($parent_code = '') {
        $output = '';
        $arr = ArrayHelper::map(
                        (new \yii\db\Query())->select(['code', 'descr'])
                                ->from('ref')
                                ->where(['=', 'cat', 'DOCUMENTSUBCATEGORY'])
                                ->andwhere(['=', 'param1', $parent_code])
                                ->orderBy(['sort' => SORT_ASC])
                                ->all(), 'code', 'descr');
        if (!empty($arr)) {
            foreach ($arr as $code => $label) {
                $output .= '<option value="' . $code . '">' . $label . '</option>';
            }
        }
        return $output;
    }

    public function actionAddtranslation($no = '') {
        $desc = 'descr';
        if(Yii::$app->language == 'en'){
            $desc = 'descr_en';
        }

        $output = '<div class="ibox float-e-margins" id="new-translation-' . $no . '">
            <input type="hidden" name="newtranslation[]" value="' . $no . '">
            <div class="ibox-title">
                <button type="button" class="btn btn-primary btn-sm" onclick="deletenewtranslation(' . $no . ')">'.M::t('app','Delete').'</button>&nbsp;&nbsp;&nbsp;
                '.M::t('app','NewTranslation').'
            </div>
            <div class="ibox-publication">
                <div class="row">
                    <div class="col-sm-4">
                        <div class="form-group">
                            <label>'.M::t('app','Language').'</label>
                            ' . Html::dropDownList('new_language_' . $no, NULL, ArrayHelper::map(
                                (new \yii\db\Query())->select(['code', $desc])
                                        ->from('ref')
                                        ->where(['=', 'cat', 'DOCUMENTLANGUAGE'])
                                        ->orderBy(['sort' => SORT_ASC])
                                        ->all(), 'code', $desc), [
                    'class' => 'form-control',]) . '
                        </div>
                    </div>
                    <div class="col-sm-8"><div class="form-group"><label>'.M::t('app','Title').'</label><input type="text" class="form-control" name="new_title_' . $no . '"></div></div>
                </div>
                <div class="form-group">
                    <label>'.M::t('app','Content').'</label>
                    <textarea class="summernote" name="new_publication_' . $no . '"></textarea>
                </div>
            </div>
        </div>';
        return $output;
    }

    public function actionDeletetranslation($id) {
        if (($model = PublicationDocumentTranslation::findOne($id)) !== null) {
            $model->delete();
        }
    }

}
