<?php

namespace backend\modules\publicationDocument;

use Yii;

/**
 * Class Module
 * @package hscstudio\mimin
 */
class Module extends \yii\base\Module
{
	/**
     * @var string
     */
    public $controllerNamespace = 'backend\modules\publicationDocument\controllers';

	/**
     *
     */
    public function init()
    {
        parent::init();
        // register translation
        $this->registerTranslations();
    }

    /**
     * Module root directory
     * @var string
     */
    private static function rootModDir() {
        return basename(__DIR__);
    }

    /**
     * register the translation
     */
    private function registerTranslations()
    {
        Yii::$app->i18n->translations['modules/' . self::rootModDir() . '/*'] = [
            'class' => 'yii\i18n\PhpMessageSource',
            'sourceLanguage' => 'en-US',
            'basePath' => '@app/modules/' . self::rootModDir() . '/messages', // change this to your module directory
            'fileMap' => [
                'modules/' . self::rootModDir() . '/app' => 'app.php', // you can add more category here
            ],
        ];
    }
    
    /**
     * translation
     */
    public static function t($category, $message, $params = [], $language = null)
    {
        return Yii::t('modules/' . self::rootModDir() . '/' . $category, $message, $params, $language);
    }
}