<?php

use yii\helpers\Html;
use yii\grid\GridView;
use backend\modules\moduleRepository\models\ModuleVersion;
use yii\helpers\ArrayHelper;

/* @var $this yii\web\View */
/* @var $searchModel backend\modules\moduleRepository\models\ModuleListSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = Yii::t('app', 'Modules Repository');
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="wrapper wrapper-content">
    <p><?= Html::a(Yii::t('app', 'Create Repository'), ['create'], ['class' => 'btn btn-primary']) ?></p>
    <div class="ibox animated fadeInRight">
        <div class="mail-box b-r-md">

            <?=
            GridView::widget([
                'dataProvider' => $dataProvider,
                'filterModel' => $searchModel,
                'tableOptions' => ['class' => 'table',],
                'summary' => '',
                'columns' => [
                    ['class' => 'yii\grid\SerialColumn'],
                    'module_name',
                    [
                        'attribute' => 'module_category',
                        'filter' => ArrayHelper::map(
                                (new \yii\db\Query())->select(['code', 'descr'])
                                        ->from('ref')
                                        ->where(['=', 'cat', 'MODULEREPOCAT'])
                                        ->orderBy(['sort' => SORT_ASC])
                                        ->all(), 'code', 'descr'),
                        'value' => function ($model) {
                            $ref = (new \yii\db\Query())->select(['descr'])
                                    ->from('ref')
                                    ->where(['=', 'cat', 'MODULEREPOCAT'])
                                    ->andwhere(['=', 'code', $model->module_category])
                                    ->one();
                            if (!empty($ref))
                                return $ref['descr'];
                        }
                    ],
                    [
                        'header' => 'Version',
                        'headerOptions' => ['style' => 'width:10%'],
                        'value' => function ($model) {
                            if (($modelversion = ModuleVersion::find()->where(['module_id' => $model->module_id])->orderBy(['version_id' => SORT_DESC])->one()) !== null) {
                                return $modelversion->module_version;
                            }
                        }
                    ],
                    [
                        'attribute' => 'module_developer',
                        'headerOptions' => ['style' => 'width:10%'],
                    ],
                    [
                        'attribute' => 'module_compatible',
                        'headerOptions' => ['style' => 'width:15%'],
                    ],
                    [
                        'attribute' => 'updated_at',
                        'headerOptions' => ['style' => 'width:10%'],
                        'value' => function ($model) {
                            return date("d-m-Y", strtotime($model->updated_at));
                        }
                    ],
                    [
                        'class' => 'yii\grid\ActionColumn',
                        'header' => 'Action',
                        'template' => '{update} {delete}',
                        'headerOptions' => ['style' => 'text-align:center;width:10%'],
                        'contentOptions' => ['style' => 'text-align:center;'],
                    ],
                ],
            ]);
            ?>
        </div>
    </div>
</div>