<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use kartik\file\FileInput;
use backend\modules\moduleRepository\models\ModuleVersion;
use yii\helpers\ArrayHelper;

/* @var $this yii\web\View */
/* @var $model backend\modules\moduleRepository\models\ModuleList */
/* @var $form yii\widgets\ActiveForm */
$this->registerCssFile('@web/plugins/summernote/summernote.min.css');
$this->registerJsFile('@web/plugins/summernote/summernote.min.js', ['depends' => [\yii\web\JqueryAsset::className()]]);
$this->registerCssFile('@web/plugins/bootstrap-tagsinput/dist/bootstrap-tagsinput.css');
$this->registerJsFile('@web/plugins/bootstrap-tagsinput/dist/bootstrap-tagsinput.min.js', ['depends' => [\yii\web\JqueryAsset::className()]]);

$this->registerJs(
        <<<JS
    $('.summernote').summernote({height: 300});
    $('#w0').on('keyup keypress', function(e) {
        var keyCode = e.keyCode || e.which;
        if (keyCode === 13) { 
          e.preventDefault();
          return false;
        }
      });
JS
);
$this->registerCss(".note-editor{border:1px solid #e5e6e7 !important}.bootstrap-tagsinput input, .bootstrap-tagsinput {width:100% !important;}");

if ($model->isNewRecord)
    $this->registerJs("addnewversion();");
?>

<div class="module-list-form">
    <?php $form = ActiveForm::begin(['options' => ['enctype' => 'multipart/form-data']]); ?>
    <div class="wrapper wrapper-content animated fadeInRight" style="padding: 20px 10px 20px;">
        <div class="ibox float-e-margins">
            <div class="ibox-content">
                <div class="row">
                    <div class="col-sm-6"><?= $form->field($model, 'module_name')->textInput(['maxlength' => true]) ?></div>
                    <div class="col-sm-6">
                        <?=
                        $form->field($model, 'module_category')->dropdownList(
                                ArrayHelper::map(
                                        (new \yii\db\Query())->select(['code', 'descr'])
                                                ->from('ref')
                                                ->where(['=', 'cat', 'MODULEREPOCAT'])
                                                ->orderBy(['sort' => SORT_ASC])
                                                ->all(), 'code', 'descr'), [
                            'maxlength' => true, 'prompt' => '-- Please choose --'])
                        ?>
                    </div>
                    <div class="col-sm-6"><?= $form->field($model, 'module_developer')->textInput(['maxlength' => true]) ?></div>
                    <div class="col-sm-6"><?= $form->field($model, 'module_compatible')->textInput(['maxlength' => true, 'placeholder' => 'E.g : Dynaweb4 V3.0.1']) ?></div>
                </div>

                *Press "Enter" to separate the tag
                <?= $form->field($model, 'module_related')->textInput(['maxlength' => true, 'data-role' => 'tagsinput']) ?>
                <?php
                if (!empty($model->module_image)) {
                    echo $form->field($model, 'module_image')->widget(FileInput::classname(), [
                        'options' => ['accept' => 'image/*'],
                        'pluginOptions' => [
                            'showUpload' => false,
                            'initialPreview' => [
                                '<img style="width:100%" src="' . Yii::getAlias('@web') . '/' . $model->module_image . '"/>',
                            ],
                        ]
                    ]);
                } else {
                    echo $form->field($model, 'module_image')->widget(FileInput::classname(), ['options' => ['accept' => 'image/*'],]);
                }
                ?>
                <?= $form->field($model, 'module_description')->textarea(['class' => 'summernote']) ?>
                <?= $form->field($model, 'module_feature')->textarea(['class' => 'summernote']) ?>
                <?= $form->field($model, 'module_instruction')->textarea(['class' => 'summernote']) ?>
                <input type="hidden" id="controller_name" value="<?php echo Yii::$app->controller->action->id; ?>">
                <h3> Modules Version</h3>
                <table class="table table-bordered" id="wrapper-version">
                    <thead><tr><th width="20%">Version</th><th>Remarks</th><th width="20%">Upload Zip File</th></tr></thead>
                    <tbody>
                        <?php
                        $modelversion = ModuleVersion::find()->where(['=', 'module_id', $model->module_id])->orderBy(['version_id' => SORT_ASC])->all();
                        if (!empty($modelversion)) {
                            foreach ($modelversion as $rowversion) {
                                echo '<tr>
                                    <td>' . $rowversion->module_version . '</td>
                                    <td>' . $rowversion->module_remarks . '</td>
                                    <td><a href="' . Yii::getAlias('@web') . '/' . $rowversion->module_url . '">ZIP File</a></td>
                                </tr>';
                            }
                        }
                        ?>
                    </tbody>
                </table>
                <div class="form-group">
                    <?= Html::button('Add New Version', ['class' => 'btn btn-primary', 'onclick' => 'addnewversion()', 'id' => 'btn-add-version']); ?>
                    <?= Html::submitButton($model->isNewRecord ? 'Create' : 'Update', ['class' => 'btn btn-primary']) ?>
                </div>
            </div>
        </div>
    </div>
    <?php ActiveForm::end(); ?>
</div>
<script>
    var newcount = 0;
    function addnewversion() {
        newcount++;
        $.ajax({
            url: "addnewversion?no=" + newcount + '&controller_name=' + $('#controller_name').val(),
            method: "GET",
            success: function (response) {
                $('#wrapper-version').append(response);
                $('#btn-add-version').hide();
            },
        });
    }
</script>