DROP TABLE IF EXISTS `module_list`;

CREATE TABLE `module_list` (
  `module_id` int(11) NOT NULL AUTO_INCREMENT,
  `module_name` varchar(255) DEFAULT NULL,
  `module_image` varchar(255) DEFAULT NULL,
  `module_description` text DEFAULT NULL,
  `module_feature` text DEFAULT NULL,
  `module_instruction` text DEFAULT NULL,
  `module_developer` varchar(255) DEFAULT NULL,
  `module_compatible` varchar(255) DEFAULT NULL,
  `module_related` text DEFAULT NULL,`module_category` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`module_id`),
  KEY `module_id` (`module_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `module_version`;

CREATE TABLE `module_version` (
  `version_id` int(11) NOT NULL AUTO_INCREMENT,
  `module_id` int(11) DEFAULT NULL,
  `module_version` varchar(255) DEFAULT NULL,
  `module_remarks` text DEFAULT NULL,
  `module_url` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`version_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `module_download`;

CREATE TABLE `module_download` (
  `download_id` int(11) NOT NULL AUTO_INCREMENT,
  `version_id` int(11) DEFAULT NULL,
  `download_at` datetime DEFAULT NULL,
  PRIMARY KEY (`download_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `ref` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cat` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `code` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `descr` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `descr_en` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sort` int(11) DEFAULT NULL,
  `param1` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `icon_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created_by` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created_at` int(11) DEFAULT NULL,
  `updated_by` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `updated_at` int(11) DEFAULT NULL,
  `deleted_at` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

insert  into `ref`(`cat`,`code`,`descr`,`descr_en`,`sort`,`param1`,`icon_name`,`created_by`,`created_at`,`updated_by`,`updated_at`,`deleted_at`) values 
('MODULEREPOCAT','backend','Backend',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('MODULEREPOCAT','content','Content',NULL,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('MODULEREPOCAT','custom','Custom',NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('MODULEREPOCAT','frontend','Frontend',NULL,4,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('MODULEREPOCAT','publication','Publication',NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('MODULEREPOCAT','media','Social Media',NULL,6,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('MODULEREPOCAT','support','Support',NULL,7,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('MODULEREPOCAT','utilities','Utilities',NULL,8,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('MODULEREPOCAT','others','Others',NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL);