<?php

namespace backend\modules\moduleRepository\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\modules\moduleRepository\models\ModuleVersion;

/**
 * ModuleVersionSearch represents the model behind the search form of `backend\modules\moduleRepository\models\ModuleVersion`.
 */
class ModuleVersionSearch extends ModuleVersion
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['version_id', 'module_id', 'created_by', 'updated_by'], 'integer'],
            [['module_version', 'module_remarks', 'module_url', 'created_at', 'updated_at'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = ModuleVersion::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'version_id' => $this->log_id,
            'module_id' => $this->module_id,
            'created_at' => $this->created_at,
            'created_by' => $this->created_by,
            'updated_at' => $this->updated_at,
            'updated_by' => $this->updated_by,
        ]);

        $query->andFilterWhere(['like', 'module_version', $this->module_version])
            ->andFilterWhere(['like', 'module_remarks', $this->module_remarks])
            ->andFilterWhere(['like', 'module_url', $this->module_url]);

        return $dataProvider;
    }
}
