<?php

namespace backend\modules\moduleRepository\models;

use Yii;

/**
 * This is the model class for table "module_version".
 *
 * @property int $log_id
 * @property int|null $module_id
 * @property string|null $module_version
 * @property string|null $module_changes
 * @property string|null $module_url
 * @property int|null $module_download
 * @property string|null $created_at
 * @property int|null $created_by
 * @property string|null $updated_at
 * @property int|null $updated_by
 */
class ModuleVersion extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'module_version';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['module_id', 'created_by', 'updated_by'], 'integer'],
            [['module_remarks'], 'string'],
            [['created_at', 'updated_at'], 'safe'],
            [['module_version', 'module_url'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'version_id' => Yii::t('app', 'Log ID'),
            'module_id' => Yii::t('app', 'Module ID'),
            'module_version' => Yii::t('app', 'Module Version'),
            'module_remarks' => Yii::t('app', 'Module Remarks'),
            'module_url' => Yii::t('app', 'Module Url'),
            'created_at' => Yii::t('app', 'Created At'),
            'created_by' => Yii::t('app', 'Created By'),
            'updated_at' => Yii::t('app', 'Updated At'),
            'updated_by' => Yii::t('app', 'Updated By'),
        ];
    }
}
