<?php

namespace backend\modules\moduleRepository\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\modules\moduleRepository\models\ModuleList;

/**
 * ModuleListSearch represents the model behind the search form of `backend\modules\moduleRepository\models\ModuleList`.
 */
class ModuleListSearch extends ModuleList {

    /**
     * {@inheritdoc}
     */
    public function rules() {
        return [
            [['module_id', 'created_by', 'updated_by'], 'integer'],
            [['module_name', 'module_image', 'module_description', 'module_feature', 'module_instruction', 'module_developer', 'module_compatible', 'module_related', 'created_at', 'updated_at','module_category'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios() {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params) {
        $query = ModuleList::find();

        // add conditions that should always apply here
        $dataProvider = new ActiveDataProvider(['query' => $query, 'pagination' => ['pageSize' => 10,]]);
        $dataProvider->setSort(['defaultOrder' => ['updated_at' => SORT_DESC]]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'module_id' => $this->module_id,
            'created_at' => $this->created_at,
            'created_by' => $this->created_by,
            'updated_at' => $this->updated_at,
            'updated_by' => $this->updated_by,
        ]);

        $query->andFilterWhere(['like', 'module_name', $this->module_name])
                ->andFilterWhere(['like', 'module_image', $this->module_image])
                ->andFilterWhere(['like', 'module_description', $this->module_description])
                ->andFilterWhere(['like', 'module_feature', $this->module_feature])
                ->andFilterWhere(['like', 'module_instruction', $this->module_instruction])
                ->andFilterWhere(['like', 'module_developer', $this->module_developer])
                ->andFilterWhere(['like', 'module_compatible', $this->module_compatible])
                ->andFilterWhere(['like', 'module_related', $this->module_related])
                ->andFilterWhere(['like', 'module_category', $this->module_category]);

        return $dataProvider;
    }

}
