<?php

namespace backend\modules\moduleRepository\models;

use Yii;

/**
 * This is the model class for table "module_list".
 *
 * @property int $module_id
 * @property string|null $module_name
 * @property string|null $module_image
 * @property string|null $module_description
 * @property string|null $module_feature
 * @property string|null $module_instruction
 * @property string|null $module_developer
 * @property string|null $module_compatible
 * @property string|null $module_related
 * @property string|null $created_at
 * @property int|null $created_by
 * @property string|null $updated_at
 * @property int|null $updated_by
 */
class ModuleList extends \yii\db\ActiveRecord {

    /**
     * {@inheritdoc}
     */
    public static function tableName() {
        return 'module_list';
    }

    /**
     * {@inheritdoc}
     */
    public function rules() {
        return [
            [['module_name', 'module_description', 'module_feature', 'module_instruction', 'module_developer', 'module_compatible', 'module_category'], 'required'],
            [['module_description', 'module_feature', 'module_instruction', 'module_related'], 'string'],
            [['created_at', 'updated_at'], 'safe'],
            [['created_by', 'updated_by'], 'integer'],
            [['module_name', 'module_image', 'module_developer', 'module_compatible'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels() {
        return [
            'module_id' => Yii::t('app', 'Module ID'),
            'module_name' => Yii::t('app', 'Module Name'),
            'module_image' => Yii::t('app', 'Thumbnail'),
            'module_description' => Yii::t('app', 'Description'),
            'module_feature' => Yii::t('app', 'Features'),
            'module_instruction' => Yii::t('app', 'Installation Instruction'),
            'module_developer' => Yii::t('app', 'Developer'),
            'module_compatible' => Yii::t('app', 'Compatible With'),
            'module_related' => Yii::t('app', 'Related Modules'),
            'module_category' => Yii::t('app', 'Category'),
            'created_at' => Yii::t('app', 'Created At'),
            'created_by' => Yii::t('app', 'Created By'),
            'updated_at' => Yii::t('app', 'Last Update'),
            'updated_by' => Yii::t('app', 'Updated By'),
        ];
    }

}
