<?php

namespace backend\modules\moduleRepository\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\modules\moduleRepository\models\ModuleDownload;

/**
 * ModuleDownloadSearch represents the model behind the search form of `backend\modules\moduleRepository\models\ModuleDownload`.
 */
class ModuleDownloadSearch extends ModuleDownload
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['download_id', 'version_id'], 'integer'],
            [['download_at'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = ModuleDownload::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'download_id' => $this->download_id,
            'version_id' => $this->version_id,
            'download_at' => $this->download_at,
        ]);

        return $dataProvider;
    }
}
