<?php

namespace backend\modules\moduleRepository\models;

use Yii;

/**
 * This is the model class for table "module_download".
 *
 * @property int $download_id
 * @property int|null $version_id
 * @property string|null $download_at
 */
class ModuleDownload extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'module_download';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['version_id'], 'integer'],
            [['download_at'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'download_id' => Yii::t('app', 'Download ID'),
            'version_id' => Yii::t('app', 'Version ID'),
            'download_at' => Yii::t('app', 'Download At'),
        ];
    }
}
